'use strict';

const Controller = require('egg').Controller;

class OrderController extends Controller {
    /**
     * 预约
     */
    async addOrder() {
        const { ctx } = this;
        let inputParams = ctx.request.body;
        const rule = {
            id: {
                type: 'integer',
                required: true,
            },
            type: {
                type: 'integer',
                required: true,
            },
            name: {
                type: 'string',
                required: true,
            },
            phone: {
                type: 'string',
                required: true,
            },
            time: {
                type: 'string',
                required: true,
            },
        };
        ctx.validate(rule, inputParams);
        let ret = await ctx.service.house.order.addOrder(inputParams);
        ctx.success(ret);
    }


    /**
     * 获取预约列表
     */
    async getOrderList() {
        const { ctx } = this;
        let ret = await ctx.service.house.order.getOrderList();
        ctx.success(ret);
    }


}

module.exports = OrderController;
