'use strict';

module.exports = app => {
    const router = app.router.namespace(app.config.projectRootPath + '/course');
    const loginAuth = app.middleware.loginAuth({ type: 'new' });//登录中间件
    const miniAuth = app.middleware.miniAuth();//登录中间件

    router.get('third', '/options', 'course.option.getOptions');//筛选项
    router.post('third', '/institutions', 'course.institution.institutionList');//机构列表
    router.get('third', '/institutions', 'course.institution.institutionList');//机构列表
    router.get('third', '/institution/:institution_id/:area_id', 'course.institution.institutionInfo');//机构详情
    router.post('third', '/classes', 'course.institution.classList');//课程列表
    router.get('third', '/classes', 'course.institution.classList');//课程列表
    router.get('third', '/class/:class_id', 'course.institution.classInfo');//课程详情
    router.post('third', '/teachers', 'course.institution.teacherList');//老师列表
    router.get('third', '/teachers', 'course.institution.teacherList');//老师详情
    router.get('third', '/teacher/:teacher_id', 'course.institution.teacherInfo');//老师详情

    router.post('third', '/user/auth', 'course.user.auth');//微信授权登录
    router.post('third', '/user/register_user', miniAuth, 'course.user.registerUserInfo');//授权后注册用户

    router.get('third', '/user/baby', 'course.user.getBabyInfo');//获取baby信息
    router.post('third', '/user/baby', 'course.user.saveBabyInfo');//保存baby信息
    router.delete('third', '/user/baby', 'course.user.delBabyInfo');//删除baby信息

    router.get('third', '/user/collection/institution', 'course.user.getCollectInstitutions');//收藏的机构列表
    router.post('third', '/user/collection/institution', 'course.user.collectInstitution');//收藏机构

};
