'use strict';

const moment = require('moment');

module.exports = app => {
  const { STRING, INTEGER, ENUM} = app.Sequelize;
  const Channel = app.blockModel.define('channel', {
    id: { type: STRING, primaryKey: true },
    app_id: STRING,
    name: STRING,
    alias: STRING,
    status: ENUM('online','offline'),
    valid: INTEGER,
  }, {
    timestamps: false,
    tableName: 'channel',
  });

  Channel.one = async (data) => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
      return await Channel.findOne({
          attributes: attributes,
          where : where,
      });
  }


  Channel.all = async (data) => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    return await Channel.findAll({
        attributes: attributes,
        where : where,
    });
  }

  Channel.list = async (data = {}) => {
    const limit = data.limit ? data.limit : 10;
    const page = data.page ? data.page : 1;
    const order = data.order ? data.order : [];
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    const condition = {
      offset: (page - 1) * limit,
      limit,
      where: where,
      order: order,
      attributes: attributes,
    };
    console.log(condition);
    const { count, rows } =  await Channel.findAndCountAll(condition);
    return { page, count, rows };
  }

  Channel.add = async (data) => {
    try {
      //返回promise对象实力 instance 
      const res = await Channel.create(data);
      //从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
      return res.id;  
    } catch(error) {
      ctx.status = 500;
      throw (error);
    }    
  }

  Channel.edit = async (data) => {
    const where = data.where;
    const params = data.params;
    Channel.update(params, {
      where: where
    }).catch( e => res.json({status: 500, error: e}));
  }

  return Channel;

};
