'use strict';

module.exports = app => {
    const router = app.router.namespace(app.config.projectRootPath + '/course');
    const loginAuth = app.middleware.loginAuth({ type: 'new' });//登录中间件

    router.get('/options', 'course.option.getOptions');
    router.post('/institutions', 'course.institution.institutionList');
    router.get('/institutions', 'course.institution.institutionList');
    router.get('/institution/:institution_id/:area_id', 'course.institution.institutionInfo');
    router.post('/classes', 'course.institution.classList');
    router.get('/classes', 'course.institution.classList');
    router.get('/class/:class_id', 'course.institution.classInfo');
    router.post('/teachers', 'course.institution.teacherList');
    router.get('/teachers', 'course.institution.teacherList');
    router.get('/teacher/:teacher_id', 'course.institution.teacherInfo');

};
