'use strict';


const moment = require('moment');

module.exports = app => {
  const { STRING, INTEGER, DATE } = app.Sequelize;

  const CourseV5Questionnaire = app.classModel.define('course_v5_questionnaire', {
    id: {
      type: INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    cat_id: INTEGER,
    user_id: STRING,
    answer_1: STRING,
    answer_2: STRING,
    answer_3: STRING,
    created_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('created_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
    updated_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('updated_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
  }, {
    timestamps: false,
    tableName: 'course_v5_questionnaire',
  });

  return CourseV5Questionnaire;

};
