'use strict';

module.exports = {

  // 获取 Token
  get_jwt() {
    const { ctx } = this;
    let bearerToken = ctx.request.header.authorization;
    if (!bearerToken) {
      ctx.failed('error auth');
    }
    return bearerToken && bearerToken.replace("Bearer ", "");
  },

  // 校验 Token
  async verify_token(ctx) {
    let token = this.get_jwt(ctx);
    let decode_res = await ctx.service.jwt.decode_token(token);
    ctx.logger.info('decode_res', decode_res)
    let token_black = await this.app.memcache.get('auth_token_' + decode_res.data.user_id);
    ctx.logger.info('token_black', token_black, token);
    if (token_black == token) {
      ctx.failed('token 已失效');
    }
    // if (ctx.request.body.user_id != decode_res.data.user_id) {
    //   ctx.failed('用户 ID 与 Token 不一致');
    // }
    return decode_res;
  },

  md5(str) {
    if (!str) {
      return '';
    }
    const crypto = require('crypto');
    const hash = crypto.createHash('md5');
    const ret = hash.update(String(str), 'utf8');
    return ret.digest('hex');
  },

  //发送请求 注意params和options都为对象
  async send_request(url, params, input_options) {
    const { ctx } = this;

    /***
    example_options = {
        //是否开启请求各阶段的时间测量
    timing: false,

    //method
    method: 'POST',

    //发送数据格式，默认以application/x-www-form-urlencoded格式发送请求
    contentType: 'json',

    //参数
    data: {
        id: 5,
        name: 'test',
    }

    //设置响应数据格式，默认不对响应数据做任何处理，直接返回原始的 buffer 格式数据。 支持 text 和 json 两种格式。
        //注意：设置成 json 时，如果响应数据解析失败会抛 JSONResponseFormatError 异常
        dataType: 'json',
    }
    ***/

    let default_options = {
      timeout: 3000,
      timing: true,
      method: 'POST',
      contentType: 'json',
      dataType: 'json',
    };

    let options = input_options ? Object.assign({}, default_options, input_options) : default_options;

    options.data = params;
    //测试接口：个税获取话题列表
    //var url = 'https://b.jianbing.com/app/geshui/social/get_topics';
    var resp = await ctx.curl(url, options);
    return resp;
  },

  aes256_cbc_encrypt(key, data) {
    const iv = '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0';
    const crypto = require('crypto');
    const cipher = crypto.createCipheriv('aes-256-cbc', key, iv);
    let crypted = cipher.update(data, 'utf8', 'binary');
    crypted += cipher.final('binary');
    crypted = new Buffer(crypted, 'binary').toString('base64');
    return crypted;
  },

  aes256_cbc_decrypt(key, crypted) {
    const iv = '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0';
    const crypto = require('crypto');
    crypted = new Buffer(crypted, 'base64').toString('binary');
    const decipher = crypto.createDecipheriv('aes-256-cbc', key, iv);
    let decoded = decipher.update(crypted, 'binary', 'utf8');
    decoded += decipher.final('utf8');
    return decoded;
  },


  aes256_cbc_decrypt_weixin(key, crypted) {
    let aesKey = Buffer.from(key + '=', 'base64');
    const cipherEncoding = 'base64';
    const clearEncoding = 'utf8';
    const cipher = crypto.createDecipheriv('aes-256-cbc', aesKey, aesKey.slice(0, 16));
    cipher.setAutoPadding(false); // 是否取消自动填充 不取消
    let decoded = cipher.update(crypted, cipherEncoding, clearEncoding) + cipher.final(clearEncoding);
    return {
      noncestr: decoded.substring(0, 16),
      msg_len: decoded.substring(16, 20),
      msg: decoded.substring(20, decoded.lastIndexOf("}") + 1)
    }
  },

  toInt(str) {
    if (typeof str === 'number') return str;
    if (!str) return str;
    return parseInt(str, 10) || 0;
  },


  //校验经纬度 部分存入的gps地址经纬度混乱，输出使用时进行校验修复
  //longitude 经线 latitude 纬度 纬度从南到北，范围为-90 - 90
  //示例：北纬N29°57′28.20″ 东经E119°42′32.30″   gps:29.9578340000,119.7089730000
  checkGps(gps) {
    
    if (!gps || gps.indexOf(',') === -1) {
      return '';
    }
    let gps_arr = gps.split(',');
    if (Math.abs(gps_arr[0]) >= 90) {
      gps_arr.reverse();
      gps = gps_arr.join(',');
    };

    return gps;
  },


  async parseGps(gps) {

    if (!gps || gps.indexOf(',') === -1) {
      return '';
    }
    let gps_arr = gps.split(',');
    if (Math.abs(gps_arr[0]) >= 90) {
      gps_arr.reverse();
      gps = gps_arr.join(',');
    };

    let data = {
      ak: '3TBenWOhPygtFFazaR5kSibU',
      pois: 0,
      output: 'json',
      location: gps,
    };
    const { ctx } = this;
    const resp = await ctx.curl('http://api.map.baidu.com/geocoder/v2/', { timeout: 3000, dataType: 'json', method: 'GET', data: data });

    const ret = resp.data;
    if (ret.status != 0) {
      return {};
    }
    return ret;
  },

  async getGPS(address, city) {
    console.info(address);
    const baidu_url = `https://api.map.baidu.com/geocoder/v2/`;
    const result = await this.send_request(baidu_url, { address: address, output: 'json', ak: '3TBenWOhPygtFFazaR5kSibU', city: city }, { method: 'GET' });
    console.info(result);
    const ret = result.data;
    if (ret && ret.status === 0 && ret.result && ret.result.location) {
      return ret.result.location;
    }
    return { lng: 0, lat: 0 };
  },

  async check_submit_frequent(redis_key, expire = 5) {
    const { ctx, app } = this;
    const redis_value = await app.memcache.get(redis_key);
    if (redis_value) {
      ctx.failed('提交太频繁了，过会在试吧~');
    }
    app.memcache.set(redis_key, 1, expire);
    return true;
  },

  randomsort(a, b) {//数组随机排序
    return Math.random() > .5 ? -1 : 1; //通过随机产生0到1的数，然后判断是否大于0.5从而影响排序，产生随机性的效果。
  },

  debug(data, mark = '') {
    var str = '';
    for (let i = 0; i <= 60; i++) {
      str += mark;
    }
    console.log(str);
    console.log(data);
    console.log(str);
  },

  sha1(...data) {
    if (!data) {
      return '';
    }
    const crypto = require('crypto');
    return crypto.createHash('sha1').update(data.sort().join('')).digest('hex');
  },

  unique(arr) {
    var res = arr.filter(function (item, index, array) {
      return array.indexOf(item) === index;
    });
    return res;
  },

  //校验身份证
  verify_id_card(id_card) {
    const id_card_reg = /(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/;
    if (id_card_reg.test(id_card) === false) {//身份证号码校验
      return false;
    }
    /*1、从第一位到第十七位的系数分别为：
      7,9,10,5,8,4,2,1,6,3,7,9,10,5,8,4,2 
      将这17位数字和系数相乘的结果相加。 */
    const arr = [7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2];
    let sum = 0;
    for (let i = 0; i < arr.length; i++) {
      sum += parseInt(id_card.charAt(i)) * arr[i];
    }
    //2、用加出来和除以11，看余数，
    const c = sum % 11;
    //3、分别对应的最后一位身份证的号码为：1－0－X－9－8－7－6－5－4－3－2
    const ch = ['1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'];
    const code = ch[c];
    let last = id_card.charAt(17);
    last = last == 'x' ? 'X' : last;
    return last == code;
  },

  //随机化原数组
  shuffle(array) {
    var m = array.length,
      t, i;
    // 如果还剩有元素…
    while (m) {
      // 随机选取一个元素…
      i = Math.floor(Math.random() * m--);
      // 与当前元素进行交换
      t = array[m];
      array[m] = array[i];
      array[i] = t;
    }
    return array;
  },

  // 获取客户端IP
  getClientIP() {
    const { ctx } = this;
    const ips = ctx.request.header['x-forwarded-for'];
    const ipList = ips ? ips.split(',') : [''];
    const ip = ipList[0];
    return ip;
  },


  JsonParse(jsonStr) {
    try {
      return JSON.parse(jsonStr);
    } catch (error) {
      return [];
    }
  },

};
