'use strict';
module.exports = app => {
    const { INTEGER, TEXT } = app.Sequelize;

    const HouseQuestion = app.blockModel.define('house_question', {
        id: {
            type: INTEGER,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true,
        },
        question_json: {
            type: TEXT,
            allowNull: true,
            field: 'question_json',
            get() {
                const question_json = this.getDataValue('question_json');
                if (question_json) {
                    try {
                        return JSON.parse(question_json);
                    } catch (error) {
                        return [];
                    }
                }
                return [];
            },
        },
    }, {
            timestamps: false,
            tableName: 'house_question',
            freezeTableName: true,
        });

    HouseQuestion.one = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        return await HouseQuestion.findOne({
            attributes: attributes,
            where: where,
        });
    }


    HouseQuestion.all = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        return await HouseQuestion.findAll({
            attributes: attributes,
            where: where,
        });
    }

    HouseQuestion.list = async (data = {}) => {
        const limit = data.limit ? data.limit : 10;
        const page = data.page ? data.page : 1;
        const order = data.order ? data.order : [];
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const condition = {
            offset: (page - 1) * limit,
            limit,
            where: where,
            order: order,
            attributes: attributes,
        };

        const { count, rows } = await HouseQuestion.findAndCountAll(condition);
        return { page, count, rows };
    }

    HouseQuestion.add = async (data) => {
        try {
            //返回promise对象实力 instance 
            const res = await HouseQuestion.create(data);
            //从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
            return res.id;
        } catch (error) {
            ctx.status = 500;
            throw (error);
        }
    }

    HouseQuestion.edit = async (data) => {
        const where = data.where;
        const params = data.params;
        HouseQuestion.update(params, {
            where: where
        }).catch(e => res.json({ status: 500, error: e }));
    }

    return HouseQuestion;

};
