'use strict';

const Controller = require('egg').Controller;

class RentalHouseController extends Controller {

  async getRentalHouses() {
    const { ctx } = this;
    const input_params = ctx.query;
    const rule = {
      brand: { type: 'string', required: false },//品牌
      district: { type: 'string', required: false },//区域
      // price: { type: 'enum', required: false, values: ['1', '2', '4', '5', '6', '7', '8', '9'] },//价格
      house_type: { type: 'enum', required: false, values: ['1', '2', '4', '5', '6'] },//房型
    };
    ctx.validate(rule, input_params);
    const ret = await ctx.service.house.rentalHouse.getRentalHousesByFilter(input_params);
    ctx.success(ret);
  }

  async getRentalHouse() {
    const { ctx } = this;
    const input_params = ctx.params;
    if (!input_params.rental_house_id) {
      ctx.failed('rental_house_id error');
    }
    const rental_house_id = input_params.rental_house_id;
    const ret = await ctx.service.house.rentalHouse.getRentalHouse(rental_house_id);
    ctx.success(ret);
  }

}

module.exports = RentalHouseController;
