'use strict';

module.exports = app => {
    const router = app.router.namespace(app.config.projectRootPath + '/house');
    const loginAuth = app.middleware.loginAuth({ type: 'new' });//登录中间件

    router.get('/options/:city_code', 'house.options.getOptions');//筛选项信息
    router.get('/rental_house', 'house.rentalHouse.getRentalHouses');//租房列表
    router.get('/rental_house/:rental_house_id', 'house.rentalHouse.getRentalHouse');//租房列表

    //新房
    router.get('/new_house/list/:type', 'house.newHouse.getNewHouseList');//列表
    router.get('/new_house/:id', 'house.newHouse.getNewHouse');//新房具体信息
    router.get('/new_house_type/:id', 'house.newHouse.getNewHouseType');//新房户型

    //预约
    router.post('/order', 'house.order.addOrder');//预约
    router.get('/order/list', 'house.order.getOrderList');//预约列表

    //收藏
    router.post('/collection', 'house.collection.addCollection');//收藏
    router.get('/collection/list', 'house.collection.getCollectionList');//收藏列表




};
