
'use strict';

const Service = require('egg').Service;
const moment = require('moment');

class CollectionService extends Service {

    /**
     * 添加收藏
     * @param {object} inputParams 
     */
    async addCollection(inputParams) {
        const { ctx, service } = this;
        let data = {
            userId: ctx.userId,
            appUserId: ctx.appUserId,
            houseStyle: inputParams.type,
            connectId: inputParams.id,
            state: 1,
            remark: inputParams.remark || ''
        }
        let ret = await service.houseCommon.collection.add(data);
        return ret;
    }


    /**
     * 获取收藏列表  保留最近6个月的记录，条数不超过50条
     * @param {object} condition 
     */
    async getCollectionList() {
        const { ctx, service } = this;
        let endDate = moment().subtract(180, 'days').format('YYYY-MM-DD HH:mm:ss');
        let filter = {
            pageIndex: 1,
            pageSize: 50,
            queryConditions: [{
                key: "state",
                value: 1,
                operator: "equal"
            }, {
                key: "userId",
                value: '33A54829-1262-40B5-BE36-B57A12DA090B',//TODO
                operator: "equal"
            },
                //  {
                //     key: "createdAt",
                //     value: endDate,
                //     operator: "greater"
                // },
            ],
            orderConditions: [{
                key: 'createdAt',
                orderSequence: 'desc',
            },],
        }

        let list = [];
        let collectionList = await service.houseCommon.collection.all(filter);
        if (collectionList.rowCount > 0) {
            //整理所有收藏
            let taskList = [];
            for (let i in collectionList.results) {
                if (collectionList.results[i].houseStyle === 1) {
                    taskList[i] = service.houseCommon.newHouse.one(collectionList.results[i].connectId);
                } else {
                    taskList[i] = service.houseCommon.rentalHouse.one(collectionList.results[i].connectId);
                }
            }

            let retList = await Promise.all(taskList).then(result => {
                return result;
            }).catch(error => {
                ctx.failed(error);
            });
            //数据整理
            for (let j in retList) {
                let type = collectionList.results[j].houseStyle;
                let tmp = {
                    id: retList[j].id,
                    name: retList[j].name,
                    address: retList[j].address,
                    tags: retList[j].tags.split(','),
                    image: retList[j].image,
                    area: type === 1 ? retList[j].houseArea : '',
                    price: type === 1 ? retList[j].referenceAvgPrice : retList[j].price,
                    type: type,
                };
                list.push(tmp);
            }
        }
        let ret = {
            results: list,
            count: list.length
        };
        return ret;
    }


}

module.exports = CollectionService;
