
'use strict';

const Service = require('egg').Service;
const R = require('ramda');
const moment = require('moment');
class HouseAnalysisService extends Service {


    //户型解析列表
    async getHouseAnalysisByFilter(condition) {

        const { ctx } = this;
        let { city_code, keyword, page, page_size, room_num, hall_num, toilet_num } = condition;
        page = page ? page : 1;
        page_size = page_size ? page_size : 10;
        let where = { status: 'pass' };
        if (city_code) {
            where.city = city_code;
        }
        if (room_num) {
            where.room_num = room_num;
        }
        if (hall_num) {
            where.hall_num = hall_num;
        }
        if (toilet_num) {
            where.toilet_num = toilet_num;
        }
        if (keyword && keyword.length !== 0) {
            where.residential = { $like: `%${keyword}%` }
        }
        const house_analysis_rows = await ctx.realestateModel.HouseAnalysis.list({ page: page, limit: Number(page_size), where: where, order: [['id', 'desc']] });
        const house_analysis = R.project(['id', 'image', 'residential', 'house_type', 'house_area', 'text'])(house_analysis_rows.rows);

        return { page: page, count: house_analysis_rows.count, results: house_analysis };

    }

    //户型解析详情
    async getHouseAnalysis(house_analysis_id) {

        const { ctx } = this;
        const house_analysis = await ctx.realestateModel.HouseAnalysis.one({ where: { id: house_analysis_id } });

        if (!house_analysis || !house_analysis.id) {
            ctx.failed('not found');
        }
        return {
            id: house_analysis.id,
            image: house_analysis.image,
            name: house_analysis.residential,
            house_type: house_analysis.house_type,
            area: house_analysis.house_area,
            description: house_analysis.text,
            status: house_analysis.status,
        }
    }

    async addHouseAnalysis(params) {

        const { ctx } = this;
        const user_id = ctx.userId;
        const app_user_id = ctx.appUserId;
        const app_id = ctx.appId;
        const app_type_id = ctx.appTypeId;
        if (!user_id || !app_user_id || !app_id || !app_type_id) {
            ctx.failed('login error');
        }
        let { name, house_type, room_num, hall_num, toilet_num, city_code, area, image } = params;
        if (!house_type) {
            house_type = `${room_num}室${hall_num}厅${toilet_num}卫`;
        }
        const data = {
            user_id,
            app_user_id,
            app_id,
            app_type_id,
            residential: name,
            house_type: house_type,
            room_num,
            hall_num,
            toilet_num,
            city: city_code,
            house_area: area,
            image: image,
            created_at: moment(new Date()).format('YYYY-MM-DD HH:mm:ss'),
        }

        const ret = await ctx.realestateModel.HouseAnalysis.add(data);

        return ret;
    }

    async getMineHouseAnalysis(condition) {

        const { ctx } = this;
        const page = condition.page ? condition.page : 1;
        const limit = condition.page_size ? condition.page_size : 10;
        const user_id = ctx.userId;
        const app_type_id = ctx.appTypeId;
        if (!user_id || !app_type_id) {
            ctx.failed('login error');
        }
        const results = await ctx.realestateModel.HouseAnalysis.list({ page: page, limit: Number(limit), where: { user_id: user_id, app_type_id: app_type_id }, order: [['id', 'desc']] });
        return results;
    }

    async formatHouseAnalysis(house_analysis) {

        const { ctx } = this;

        if (!Array.isArray(house_analysis) || house_analysis.length === 0) {
            return [];
        }

        const ret = house_analysis.map(item => { return { id: item.id, name: item.residential, status: item.status, house_type: item.house_type, area: item.house_area, description: item.text, image: item.image } });

        return ret;
    }

}

module.exports = HouseAnalysisService;
