'use strict';

const moment = require('moment');

module.exports = app => {
  const { STRING, INTEGER, DATE, ENUM} = app.Sequelize;
  const OfficialJobApply = app.blockModel.define('official_job_apply', {
    id: { type: STRING, primaryKey: true, autoIncrement: true },
    job_id: INTEGER,
    name: STRING,
    telephone: STRING,
    email: STRING,
    school: STRING,
    major: STRING,
    resume: STRING,
    status: INTEGER,
    is_deleted: INTEGER,
    created_time: {
      type: DATE,
      get() {
        const date = this.getDataValue('created_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
    updated_time: {
      type: DATE,
      get() {
        const date = this.getDataValue('updated_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
  }, {
    timestamps: false,
    tableName: 'official_job_apply',
  });

  OfficialJobApply.one = async (data) => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
      return await OfficialJobApply.findOne({
          attributes: attributes,
          where : where,
      });
  }


  OfficialJobApply.all = async (data) => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    return await OfficialJobApply.findAll({
        attributes: attributes,
        where : where,
    });
  }

  OfficialJobApply.list = async (data = {}) => {
    const limit = data.limit ? data.limit : 10;
    const page = data.page ? data.page : 1;
    const order = data.order ? data.order : [];
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    const condition = {
      offset: (page - 1) * limit,
      limit,
      where: where,
      order: order,
      attributes: attributes,
    };
    console.log(condition);
    const { count, rows } =  await OfficialJobApply.findAndCountAll(condition);
    return { page, count, rows };
  }

  OfficialJobApply.add = async (data) => {
    try {
      //返回promise对象实力 instance 
      const res = await OfficialJobApply.create(data);
      //从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
      console.log(res);
      return res.id;  
    } catch(error) {
      ctx.status = 500;
      throw (error);
    }    
  }

  OfficialJobApply.edit = async (data) => {
    const where = data.where;
    const params = data.params;
    OfficialJobApply.update(params, {
      where: where
    }).catch( e => res.json({status: 500, error: e}));
  }

  return OfficialJobApply;

};
