'use strict';

const moment = require('moment');

module.exports = app => {
    const { STRING, INTEGER, ENUM, TEXT, DATE, DECIMAL } = app.Sequelize;
    const CdPresellHouse = app.realestateModel.define('cd_presell_house', {
        id: {
            type: INTEGER,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true,
        },
        name: {
            type: STRING,
            allowNull: true
        },
        phone: {
            type: STRING,
            allowNull: true
        },
        presell_permit: {
            type: STRING,
            allowNull: true
        },
        purpose: {
            type: STRING,
            allowNull: true
        },
        presell_area: {
            type: DECIMAL,
            allowNull: true
        },
        market_time: {
            type: DATE,
            get() {
                const date = this.getDataValue('market_time');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        status: {
            type: ENUM('online', 'offline'),
            allowNull: true
        },
        valid: {
            type: INTEGER,
            allowNull: true
        },
        created_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('created_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        updated_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('updated_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        deleted_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('deleted_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
    }, {
            timestamps: false,
            tableName: 'cd_presell_house',
        });

    return CdPresellHouse;

};
