'use strict';

const Controller = require('egg').Controller;
class ProductController extends Controller {

  // 筛选项列表
  async getOptionProducts() {

    const { ctx } = this;
    const type = ctx.params.type || 'credit';

    const keys = ctx.query.keys ? ctx.query.keys.split(',') : [];
    const results = await ctx.service.gjj.product.getRecommendOptions(type, keys);
    let suit_options;
    let credit_loans = [];
    let common_loans = [];
    let common_credits = [];
    let credit_cards = [];
    if (type === 'loan') {
      suit_options = await ctx.service.gjj.product.getLoanChannelSuitOptions();
      if (suit_options) {
        results.unshift(suit_options);
      }
      credit_loans = await ctx.service.gjj.product.getAllProductsByType(1);
      common_loans = await ctx.service.gjj.product.getAllProductsByType(4);
    } else {
      credit_cards = await ctx.service.gjj.product.getAllProductsByType(2);
      common_credits = await ctx.service.gjj.product.getAllProductsByType(3);
    }

    ctx.success({ results, credit_loans, common_loans, common_credits, credit_cards });
  }
}
module.exports = ProductController;
