'use strict';

const moment = require('moment');

module.exports = app => {
    const { INTEGER, STRING, DATE, TEXT } = app.Sequelize;
    const CreditLogYys = app.prometheusModel.define('credit_log_yys', {
        id: {
            type: INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        r_order_sn: STRING,
        user_id: STRING,
        app_user_id: STRING,
        app_id: STRING,
        app_type_id: STRING,
        request_url: STRING,
        params: STRING,
        resp: TEXT,
        valid: INTEGER,
        created_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('created_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        updated_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('updated_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        }
    }, {
        timestamps: false,
        tableName: 'credit_log_yys',
    });

    return CreditLogYys;

};
