'use strict';

module.exports = app => {
  const router = app.router.namespace(app.config.projectRootPath + '/course/v2');
  const loginAuth = app.middleware.loginAuth({ type: 'new' });// 登录中间件
  const miniAuth = app.middleware.miniAuthV2();// 因为不跟现有的用户中心系统，所以使用单独的登录中间件

  // 版本二
  router.get('third', '/cats', 'course.v2.institution.getCats');// 分类
  router.get('third', '/options', 'course.v2.option.getOptions');// 筛选项
  router.get('third', '/banners', 'course.v2.option.getBanners');// banner
  router.post('third', '/address', miniAuth, 'course.v2.location.getAddress');// 根据经纬度或ip获取地理位置信息
  router.get('third', '/institutions', miniAuth, 'course.v2.institution.getInstitutions');// 机构列表
  router.get('third', '/institution/:institution_id', miniAuth, 'course.v2.institution.getInstitution');// 机构详情
  router.get('third', '/classes', miniAuth, 'course.v2.institution.getClasses');// 课程列表
  router.get('third', '/class/:class_id', miniAuth, 'course.v2.institution.getClass');// 课程详情
  router.get('third', '/teachers', miniAuth, 'course.v2.institution.getTeachers');// 老师列表
  router.get('third', '/teacher/:teacher_id', miniAuth, 'course.v2.institution.getTeacher');// 老师详情

  router.post('third', '/user/auth', 'course.v2.user.auth');// 微信授权登录
  router.post('third', '/user/register_user', miniAuth, 'course.v2.user.registerUserInfo');// 授权后注册用户

  router.get('third', '/user/baby', miniAuth, 'course.v2.user.getBabyInfo');// 获取baby信息
  router.post('third', '/user/baby', miniAuth, 'course.v2.user.saveBabyInfo');// 保存baby信息
  router.delete('third', '/user/baby', miniAuth, 'course.v2.user.delBabyInfo');// 删除baby信息

  router.get('third', '/user/collection/institution', miniAuth, 'course.v2.institution.getUserCollectedInstitutions');// 收藏的机构列表
  router.post('third', '/user/collection/institution', miniAuth, 'course.v2.user.collectInstitution');// 收藏机构
  router.delete('third', '/user/collection/institution', miniAuth, 'course.v2.user.delCollectInstitution');// 取消收藏机构

  router.get('third', '/wechat/callbackAction', 'course.v2.wechat.check');
  router.post('third', '/wechat/callbackAction', 'course.v2.wechat.callbackAction');
  router.post('third', '/wechat/test', 'course.v2.wechat.test');

  router.get('third', '/comments', miniAuth, 'course.v2.institution.getComments');// 评论列表
  router.get('third', '/search/hot', miniAuth, 'course.v2.institution.getHotSearch');// 热搜
  router.get('third', '/search/suggest', miniAuth, 'course.v2.institution.getSuggestSearch');// 搜索联想
  router.get('third', '/search', miniAuth, 'course.v2.institution.search');// 搜索
  router.get('third', '/user/search', miniAuth, 'course.v2.institution.getUserSearch');// 用户搜索历史
  router.delete('third', '/user/search', miniAuth, 'course.v2.institution.deleteUserSearch');// 清空用户搜索记录

};
