'use strict';

const Controller = require('egg').Controller;

class CheckController extends Controller {
    /**
     * 获取用户手机
     */
    async getUserHidePhone() {
        const { ctx } = this;
        let ret = await ctx.service.duxiaoman.check.getUserHidePhone();
        ctx.success(ret);
    }

    /**
     * 获取度小满查询结果
     */
    async getCheck() {
        const { ctx } = this;
        let params = ctx.request.query;
        ctx.logger.info('params:-----' + JSON.stringify(params));
        let businessId = params['business_id'] ? Number(params['business_id']) : 142;
        const ret = await ctx.service.duxiaoman.check.check(businessId);
        ctx.success(ret);
    }

}

module.exports = CheckController;
