
'use strict';

const moment = require('moment');

module.exports = app => {
    const { STRING, INTEGER, DATE, DECIMAL, TEXT, ENUM } = app.Sequelize;

    const NewHouse = app.realestateModel.define('new_house', {
        id: {
            type: INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        name: {
            type: STRING,
            allowNull: false
        },
        developer_id: {
            type: INTEGER,
            allowNull: true
        },
        province: {
            type: INTEGER,
            allowNull: true
        },
        city: {
            type: INTEGER,
            allowNull: true
        },
        area: {
            type: INTEGER,
            allowNull: true
        },
        address: {
            type: STRING,
            allowNull: true
        },
        gps: {
            type: STRING,
            allowNull: true
        },
        sale_gps: {
            type: STRING,
            allowNull: true
        },
        sale_province: {
            type: INTEGER,
            allowNull: true
        },
        sale_city: {
            type: INTEGER,
            allowNull: true
        },
        sale_area: {
            type: INTEGER,
            allowNull: true
        },
        sale_address: {
            type: INTEGER,
            allowNull: true
        },
        tags: {
            type: STRING,
            allowNull: true
        },
        sale_type: {
            type: INTEGER,
            allowNull: true
        },
        house_type: {
            type: INTEGER,
            allowNull: true
        },
        reference_avg_price: {
            type: DECIMAL,
            allowNull: true
        },
        reference_total_price: {
            type: DECIMAL,
            allowNull: true
        },
        image: {
            type: STRING,
            allowNull: true
        },
        corner: {
            type: STRING,
            allowNull: true
        },
        discount: {
            type: DECIMAL,
            allowNull: true
        },
        favourable_info: {
            type: STRING,
            allowNull: true
        },
        decoration_type: {
            type: INTEGER,
            allowNull: true
        },
        description: {
            type: TEXT,
            allowNull: true
        },
        open_date: {
            type: DATE,
            allowNull: true,
            get() {
                const date = this.getDataValue('open_date');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        due_date: {
            type: DATE,
            allowNull: true,
            get() {
                const date = this.getDataValue('due_date');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        plan_rooms: {
            type: INTEGER,
            allowNull: true
        },
        plan_parks: {
            type: INTEGER,
            allowNull: true
        },
        plan_near_by: {
            type: TEXT,
            allowNull: true
        },
        pre_sale_permit: {
            type: STRING,
            allowNull: true
        },
        pre_sale_permit_date: {
            type: STRING,
            allowNull: true
        },
        building_numbers: {
            type: STRING,
            allowNull: true
        },
        order_id: {
            type: INTEGER,
            allowNull: true
        },
        is_reality: {
            type: INTEGER,
            allowNull: true
        },
        status: {
            type: ENUM('offline', 'online'),
            allowNull: true
        },
        valid: {
            type: INTEGER,
            allowNull: true
        },
        remark: {
            type: STRING,
            allowNull: true
        },
        option_city_code: {
            type: INTEGER,
            allowNull: true
        },
        option_district_code: {
            type: INTEGER,
            allowNull: true
        },
        option_bizicircle_code: {
            type: INTEGER,
            allowNull: true
        },
        residential_property_right_years: {
            type: INTEGER,
            allowNull: true
        },
        residential_property_fee: {
            type: STRING,
            allowNull: true
        },
        residential_property_company: {
            type: STRING,
            allowNull: true
        },
        residential_heat_supply_type: {
            type: STRING,
            allowNull: true
        },
        residential_water_suppler_type: {
            type: STRING,
            allowNull: true
        },
        residential_power_suppler_type: {
            type: STRING,
            allowNull: true
        },
        residential_land_area: {
            type: DECIMAL,
            allowNull: true
        },
        residential_house_area: {
            type: DECIMAL,
            allowNull: true
        },
        residential_area_ratio: {
            type: DECIMAL,
            allowNull: true
        },
        residential_green_ratio: {
            type: DECIMAL,
            allowNull: true
        },
        residential_arch_type: {
            type: INTEGER,
            allowNull: true
        },
        residential_nearby: {
            type: TEXT,
            allowNull: true
        },
        deleted_at: {
            type: DATE,
            allowNull: true,
            get() {
                const date = this.getDataValue('deleted_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        updated_at: {
            type: DATE,
            allowNull: true,
            get() {
                const date = this.getDataValue('updated_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        created_at: {
            type: DATE,
            allowNull: true,
            get() {
                const date = this.getDataValue('created_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
    }, {
            timestamps: false,
            tableName: 'new_house',
        });


    NewHouse.one = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        return await NewHouse.findOne({
            attributes: attributes,
            where: where,
        });
    }


    NewHouse.all = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const order = data.order ? data.order : [];
        return await NewHouse.findAll({
            attributes: attributes,
            where: where,
            order,
        });
    }

    NewHouse.list = async (data = {}) => {
        const limit = data.limit ? Number(data.limit) : 10;
        const page = data.page ? data.page : 1;
        const order = data.order ? data.order : [];
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const condition = {
            offset: (page - 1) * limit,
            limit,
            where: where,
            order: order,
            attributes: attributes,
        };
        const { count, rows } = await NewHouse.findAndCountAll(condition);
        return { page, count, rows };
    }

    NewHouse.add = async (data) => {
        try {
            //返回promise对象实力 instance 
            const res = await NewHouse.create(data);
            //从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
            return res.id;
        } catch (error) {
            throw (error);
        }
    }

    NewHouse.edit = async (data) => {

        const where = data.where;
        const params = data.params;
        try {
            return await NewHouse.update(params, { where: where })
        } catch (error) {
            throw (error);
        }
    }
    return NewHouse;

};