'use strict';
const Controller = require('egg').Controller;
const R = require('ramda');
const moment = require('moment');
class ToolController extends Controller {

    //公积金房贷测算
    async gjjLoanMeasureInfo() {

        const { ctx } = this;
        const app_user_id = ctx.appUserId;
        // const app_user_id = '23b6c1a6-87b8-4a3d-bf87-6a48d4cd5fdb';
        const token = ctx.cookies.get('token', { signed: false });
        // const token = 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJkYXRhIjp7ImFwcF91c2VyX2lkIjoiMjNiNmMxYTYtODdiOC00YTNkLWJmODctNmE0OGQ0Y2Q1ZmRiIiwicGFzc3BvcnQiOiIxNTY1NTIwNzc5OCIsImFwcF9pZCI6IjM1M2MyZjRhLTVlZjgtNDQxOC05MDgyLTM1MzRiOWM4MDJkYyIsInVpZCI6ImVhYWY5ZDZkLTVkOTgtNDZhYi04YmJlLTYzOTAwNDZhZmJlZiIsImxvZ2luX3R5cGUiOiIxIiwiYWNjb3VudF9pZCI6IjFhNTYyZTQ3LTg1NDQtNDllNC04ZDI1LTkzNTgxMWI1YjQzOCIsImNoYW5uZWxfaWQiOiI5N2Y2MTA2MC00YWMxLTExZTktYTJhMC1hZGQxYWU3MzQyOWIiLCJkZXZpY2VfaWQiOiI2NzVmNmFhMS1iNGE0LTRmNjMtYjc1Ni1jY2JiZmIzZjk0ODciLCJvaWQiOiI4MTU2NDMiLCJkZXZpY2VfbG9naW5fbG9nc19pZCI6IjUyNDc4ZTliLTM4MmUtNDcyYy05NjA4LTY2M2VjMTk3MzQ1ZSIsImFwcF90eXBlX2lkIjoiMjE1MGQwZjEtZWUwNy00ZDE3LWEwMTktMjUxYmUzNjk5YmQxIn0sImV4cCI6MTU2MTYwNjc4NSwiaWF0IjoxNTU5MDQwNDI1fQ.tIz28GI9uCt8XWD32LCxyCq2SxzhWbaLxYKcu5aKC1E';

        const area = ctx.params.area;
        let months;
        let balance;
        if (app_user_id) {
            const url = this.config.NODE_BASE_URL + `/career-server/house/gjj_quota/${area}/${app_user_id}`;
            const gjj_loan_measure_results = await ctx.curl(url, { method: 'GET', headers: { Authorization: 'Bearer ' + token }, dataType: 'json' });
            ctx.logger.info(JSON.stringify({ url: url, gjj_loan_measure_results: gjj_loan_measure_results }));
            if (gjj_loan_measure_results.status === 200 && gjj_loan_measure_results.data && gjj_loan_measure_results.data.ret) {
                const measure_info = gjj_loan_measure_results.data.ret;
                months = measure_info.months;
                balance = measure_info.balance;
            }
        }

        ctx.success({ months, balance });
    }

    //存钱罐地图搜索
    async getMapHouses() {
        const { ctx } = this;
        const input_parmas = ctx.query;
        const rule = {
            house_style: { type: 'string', required: true },
            keyword: { type: 'string', required: true },
            // page: { type: 'string', required: false },
        }
        ctx.validate(rule, input_parmas);
        const house_style = input_parmas.house_style;
        const keyword = input_parmas.keyword;
        const page = input_parmas.page;
        const where = { where: { name: { $like: `%${keyword}%` } } };
        let results = [];
        let map_houses_results;
        if (house_style === 'used_house') {
            map_houses_results = await ctx.blockModel.HousePriceMap3.all(where);
            const map_houses = map_houses_results;
            for (let i in map_houses) {
                const item = map_houses[i];
                if (('price' in item) && !item.price) {
                    continue;
                }
                results.push({
                    id: item.id,
                    name: item.name,
                    longitude: item.longitude,
                    latitude: item.latitude,
                    price: item.price,
                    unit: item.unit || '元/平',
                    level: 3,
                });
            }
        } else if (house_style === 'new_house') {
            map_houses_results = await ctx.blockModel.HouseNewHousePriceMap2.all(where);
            const map_houses = map_houses_results;
            for (let i in map_houses) {
                const item = map_houses[i];
                if (('price' in item) && !item.price) {
                    continue;
                }
                if (('count' in item) && !item.count) {
                    continue;
                }
                results.push({
                    id: item.id,
                    name: item.name,
                    longitude: item.longitude,
                    latitude: item.latitude,
                    price: item.price,
                    count: item.count,
                    unit: item.unit || '个楼盘',
                    level: 2,
                });
            }
        }

        ctx.success({ results });

    }

    //存钱罐地图
    async getMapPoint() {
        const { ctx } = this;
        const input_parmas = ctx.params;
        const rule = {
            house_style: { type: 'string', required: true },
            area_code: { type: 'string', required: true },
            level: { type: 'string', required: true },
        }
        ctx.validate(rule, input_parmas);

        const house_style = input_parmas.house_style;
        const area_code = input_parmas.area_code;
        const level = input_parmas.level;

        let ret = [];
        if (house_style === 'used_house') {
            ret = await ctx.service.house.v2.tool.getUsedHouseMapPoint(area_code, level);
        } else if (house_style === 'new_house') {
            ret = await ctx.service.house.v2.tool.getNewHouseMapPoint(area_code, level);
        }

        ctx.success({ results: ret });
    }

    //生成购房计划
    async generateBuyHousePlan() {

        const { ctx } = this;
        const input_parmas = ctx.request.body;
        const rule = {
            area_code: { type: 'string', required: true },
            area_name: { type: 'string', required: true },
            down_payment: { type: 'string', required: true },
            invest_payment: { type: 'string', required: true },
            total_price: { type: 'string', required: true },
            prepare_time: { type: 'string', required: true },
            house_style: { type: 'string', required: false },
        }
        ctx.validate(rule, input_parmas);
        if (!parseFloat(input_parmas.invest_payment)) {
            ctx.failed('现有金额不能为0');
        }
        if (!parseFloat(input_parmas.total_price)) {
            ctx.failed('面积不能为0');
        }
        // const target_house = await ctx.blockModel.HousePriceMap.one({ where: { id: input_parmas.area_code } });
        const area_code = input_parmas.area_code;
        const total_price = parseFloat(input_parmas.total_price);
        const area_name = input_parmas.area_name;

        const house_style = input_parmas.house_style ? input_parmas.house_style : 'new_house';


        let filter = {
            total_price: { min: total_price - 30, max: total_price + 30 },
            area_code: { bizcircle_code: area_code },
        }
        let recommend_houses = await ctx.service.house.v2.newHouse.getNewHouseList(filter);//推荐房源

        let house_map;
        let district_code;
        if (recommend_houses.count === 0) {

            if (house_style === 'new_house') {
                house_map = await ctx.blockModel.HouseNewHousePriceMap2.one({ where: { id: area_code } });
            } else if (house_style === 'used_house') {
                house_map = await ctx.blockModel.HousePriceMap3.one({ where: { id: area_code } });
            }
            district_code = (house_map && house_map.pid) ? house_map.pid : '';

            filter.area_code = { district_code: district_code }
            recommend_houses = await ctx.service.house.newHouse.getNewHouseList(filter);//推荐房源
        }

        if (recommend_houses.count === 0) {

            let city_code;
            if (house_style === 'new_house') {
                house_map = await ctx.blockModel.HouseNewHousePriceMap.one({ where: { id: district_code } });
            } else if (house_style === 'used_house') {
                house_map = await ctx.blockModel.HousePriceMap2.one({ where: { id: district_code } });
                house_map = await ctx.blockModel.HousePriceMap.one({ where: { id: house_map.pid } });
            }
            city_code = (house_map && house_map.pid) ? house_map.pid : '';
            filter.area_code = { city_code: city_code };
            recommend_houses = await ctx.service.house.v2.newHouse.getNewHouseList(filter);//推荐房源
        }
        recommend_houses = recommend_houses.results.splice(0, 4);
        // const recommend_houses = [];//推荐房源

        const house_plan = await ctx.service.house.v2.tool.generateHousePlan(input_parmas);//计算购房能力 生成购房计划
        let fine_houses = [];
        if (house_plan.status !== 0) {
            filter = {
                name: area_name,
            }
            fine_houses = await ctx.service.house.v2.newHouse.getNewHouseList(filter);//推荐房源
            fine_houses = fine_houses.results.splice(0, 1);
        }
        const ret = {
            house_plan,
            fine_houses,
            recommend_houses,
        }

        ctx.success({ results: ret });
    }

    //type类型；trend：房价走势图；increase：房价涨跌 ;question: 购房问题；supply：供需趋势图
    async getHousePriceFeature() {

        const { ctx } = this;
        const input_parmas = ctx.params;
        const rule = {
            type: { type: 'string', required: true },
            area_code: { type: 'string', required: true },
        }
        ctx.validate(rule, input_parmas);

        const type = input_parmas.type;
        const area_code = input_parmas.area_code;
        let ret = [];
        if (type === 'trend') {
            ret = await ctx.blockModel.HousePriceTrend.one({ where: { id: area_code } });
            ret = ret ? ret.trend_json : [];
        } else if (type === 'increase') {
            ret = await ctx.blockModel.HousePriceIncrease.one({ where: { id: area_code } });
            ret = ret ? ret.increase_json : [];
        } else if (type === 'question') {
            ret = await ctx.blockModel.HouseQuestion.one({ where: { id: area_code } });
            ret = ret ? ret.question_json : [];
        } else if (type === 'supply') {
            ret = await ctx.blockModel.HouseSupplyDemand.one({ where: { id: area_code } });
            ret = ret ? ret.supply_demand_json : [];
        }

        ctx.success(ret);
    }

    //房价指数可支持的城市
    async getHousePriceFeatureCity() {

        const { ctx } = this;
        const results = await ctx.blockModel.HousePriceCity.all({});
        const city_codes = R.pluck('id', results);
        const cities = await ctx.blockModel.City.all({ where: { code: { $in: city_codes } }, order: [['pinyin', 'asc']] });

        ctx.success({ results: cities });
    }

    //城市月参考均价
    async getHousePriceCity() {

        const { ctx } = this;
        const city_code = ctx.query.city_code;
        let result = await ctx.blockModel.HousePriceCity.one({ where: { id: city_code } });
        let city;
        if (result && result.id) {
            city = await ctx.blockModel.City.one({ where: { code: result.id } });
        }
        if (!city) {//如果价格城市不支持 则直接取第一个 产品要求默认北京，以防爬取过来的数据没有北京所以默认第一个 表里北京基本会是第一个
            result = await ctx.blockModel.HousePriceCity.one({});
        }
        if (result && result.id) {
            city = await ctx.blockModel.City.one({ where: { code: result.id } });
        }
        const month = moment(new Date()).format('MM');
        const ret = {
            city_name: city.name,
            description: `${month}月参考均价`,
            price: result.price,
            unit: '元/平',
        }

        ctx.success({ result: ret });

    }

    //房产估价


    //并无实际用途  只用于调试测试用
}

module.exports = ToolController;
