
'use strict';

const moment = require('moment');

module.exports = app => {
    const { STRING, INTEGER, DATE, DECIMAL, TEXT } = app.Sequelize;

    const NewHouseType = app.realestateModel.define('new_house_type', {
        id: {
            type: INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        new_house_id: {
            type: INTEGER,
            allowNull: false
        },
        type: {
            type: INTEGER,
            allowNull: true
        },
        image: {
            type: STRING,
            allowNull: true
        },
        tags: {
            type: STRING,
            allowNull: true
        },
        apartment: {
            type: STRING,
            allowNull: true
        },
        sale_type: {
            type: INTEGER,
            allowNull: true
        },
        area: {
            type: DECIMAL,
            allowNull: true
        },
        orientation: {
            type: STRING,
            allowNull: true
        },
        num: {
            type: INTEGER,
            allowNull: true
        },
        price: {
            type: INTEGER,
            allowNull: true
        },
        discount: {
            type: DECIMAL,
            allowNull: true
        },
        state: {
            type: INTEGER,
            allowNull: true
        },
        remark: {
            type: STRING,
            allowNull: true
        },
        deleted_at: {
            type: DATE,
            allowNull: true,
            get() {
                const date = this.getDataValue('deleted_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        updated_at: {
            type: DATE,
            allowNull: true,
            get() {
                const date = this.getDataValue('updated_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        created_at: {
            type: DATE,
            allowNull: true,
            get() {
                const date = this.getDataValue('created_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        }
    }, {
            timestamps: false,
            tableName: 'new_house_type',
        });

        NewHouseType.one = async (data) => {
            const attributes = data.attributes ? data.attributes : {};
            const where = data.where ? data.where : {};
            return await NewHouseType.findOne({
                attributes: attributes,
                where: where,
            });
        }
    
    
        NewHouseType.all = async (data) => {
            const attributes = data.attributes ? data.attributes : {};
            const where = data.where ? data.where : {};
            const order = data.order ? data.order : [];
            return await NewHouseType.findAll({
                attributes: attributes,
                where: where,
                order,
            });
        }
    
        NewHouseType.list = async (data = {}) => {
            const limit = data.limit ? data.limit : 10;
            const page = data.page ? data.page : 1;
            const order = data.order ? data.order : [];
            const attributes = data.attributes ? data.attributes : {};
            const where = data.where ? data.where : {};
            const condition = {
                offset: (page - 1) * limit,
                limit,
                where: where,
                order: order,
                attributes: attributes,
            };
            const { count, rows } = await NewHouseType.findAndCountAll(condition);
            return { page, count, rows };
        }
    
        NewHouseType.add = async (data) => {
            try {
                //返回promise对象实力 instance 
                const res = await NewHouseType.create(data);
                //从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
                return res.id;
            } catch (error) {
                throw (error);
            }
        }
    
        NewHouseType.edit = async (data) => {
    
            const where = data.where;
            const params = data.params;
            try {
                return res = await NewHouseType.update(params, { where: where })
            } catch (error) {
                throw (error);
            }
        }

    return NewHouseType;

};