// app/service/user.js
'use strict';
const Service = require('egg').Service;
const moment = require('moment');

class UserService extends Service {
  /**
     * 通过用户编号获取手机号(校验token)
     * @param {*} data user_sid
     * @param {*} data token
     */
  async get_phone_by_user_sid(data) {
    const { ctx } = this;
    const ret = {
      phone: '',
    };
    if (!data.user_sid || !data.token) {
      return ret;
    }
    // 校验用户和token匹配问题
    let userSid = data.user_sid;
    const token = data.token;
    const authToken = await ctx.helper.md5(String(userSid) + moment().format('MDYYYY') + 'f74jkdsy83sjf', 'utf8');
    ctx.logger.info('get_phone_by_user_sid_params:' + JSON.stringify(data));
    ctx.logger.info('authToken:' + authToken);
    if (token != authToken) {
      const authTokenYesterday = await ctx.helper.md5(String(userSid) + moment().subtract(1, 'days').format('MDYYYY') + 'f74jkdsy83sjf', 'utf8');
      if (authToken != authTokenYesterday) {
        return ret;
      }
    }
    // 根据主键查找用户信息
    userSid = isNaN(userSid) ? ctx.helper.decodeUserSid(userSid) : userSid;
    const filter = { where: { sid: userSid } };
    const userInfo = await ctx.gjjModel.SysUser.one(filter);
    ctx.logger.info('get_phone_by_user_sid:' + JSON.stringify(userInfo));
    if (userInfo === null) {
      return ret;
    }
    ret.phone = userInfo.passport;

    return ret;
  }
}

module.exports = UserService;
