'use strict';

const Controller = require('egg').Controller;

class QuestionController extends Controller {

    /**
     * 提问
     */
    async addQuestion() {
        const { ctx } = this;
        let inputParams = ctx.request.body;
        const rule = {
            question: { type: 'string', required: true },
            city_code: { type: 'integer', required: true },
        };
        ctx.validate(rule, inputParams);
        if (inputParams.question.length > 100) {
            ctx.failed('提问最多100个字符');
        }
        let ret = await ctx.service.house.v2.hotQuestionPut.addQuestion(inputParams);
        ctx.success(ret);
    }

    /**
     * 我的问题
     */
    async mineQuestion() {
        const { ctx } = this;
        let inputParams = ctx.request.body;
        const rule = {
            page: { type: 'integer', required: false },
            limit: { type: 'integer', required: false },
        };
        ctx.validate(rule, inputParams);
        let ret = await ctx.service.house.v2.hotQuestionPut.mineQuestion(inputParams);
        ctx.success(ret);
    }

    /**
     * 问题列表
     */
    async questionList() {
        const { ctx } = this;
        let inputParams = ctx.request.body;
        const rule = {
            page: { type: 'integer', required: false },
            limit: { type: 'integer', required: false },
            city_code: { type: 'integer', required: true },
        };
        ctx.validate(rule, inputParams);
        let ret = await ctx.service.house.v2.hotQuestionPut.questionList(inputParams);
        ctx.success(ret);
    }

    /**
     * 问题详情
     */
    async questionDetail() {
        const { ctx } = this;
        let inputParams = ctx.request.body;
        const rule = {
            id: { type: 'integer', required: false },
            page: { type: 'integer', required: false },
            limit: { type: 'integer', required: true },
        };
        ctx.validate(rule, inputParams);
        let ret = await ctx.service.house.v2.hotQuestionPut.questionDetail(inputParams);
        ctx.success(ret);
    }

}

module.exports = QuestionController;
