'use strict';

const moment = require('moment');

module.exports = app => {
    const { INTEGER, STRING, DATE, TEXT, DECIMAL } = app.Sequelize;
    const CreditOrder = app.prometheusModel.define('credit_order', {
        id: {
            type: INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        order_no: STRING,
        apply_id: INTEGER,
        report_id: INTEGER,
        type: INTEGER,
        user_id: STRING,
        app_user_id: STRING,
        app_id: STRING,
        app_type_id: STRING,
        price: DECIMAL,
        preferential_id: INTEGER,
        preferential_price: DECIMAL,
        final_price: DECIMAL,
        state: STRING,
        state_time: {
            type: DATE,
            get() {
                const date = this.getDataValue('state_time');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        pay_status: STRING,
        pay_method: STRING,
        valid: INTEGER,
        created_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('created_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        updated_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('updated_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        },
        deleted_at: {
            type: DATE,
            get() {
                const date = this.getDataValue('deleted_at');
                return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
            },
        }
    }, {
        timestamps: false,
        tableName: 'credit_order',
    });

    return CreditOrder;

};
