'use strict';

const moment = require('moment');

module.exports = app => {
  const { STRING, INTEGER, DATE, ENUM, TEXT } = app.Sequelize;
  const ZhirenInvestment = app.huodongModel.define('zhiren_investment', {
    id: { type: INTEGER, primaryKey: true, autoIncrement: true },
    title: STRING,
    description: STRING,
    file_url: STRING,
    type_id: INTEGER,
    language: INTEGER,
    status: INTEGER,
    is_deleted: INTEGER,
    created_time: {
      type: DATE,
      get() {
        const date = this.getDataValue('created_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
    updated_time: {
      type: DATE,
      get() {
        const date = this.getDataValue('updated_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
  }, {
      timestamps: false,
      tableName: 'zhiren_investment',
    });

    ZhirenInvestment.one = async (data) => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    return await ZhirenInvestment.findOne({
      attributes: attributes,
      where: where,
    });
  }


  ZhirenInvestment.all = async (data) => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    return await ZhirenInvestment.findAll({
      attributes: attributes,
      where: where,
    });
  }

  ZhirenInvestment.list = async (data = {}) => {
    const limit = data.limit ? data.limit : 10;
    const page = data.page ? data.page : 1;
    const order = data.order ? data.order : [];
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    const condition = {
      offset: (page - 1) * limit,
      limit,
      where: where,
      order: order,
      // attributes: attributes,
    };
    const { count, rows } = await ZhirenInvestment.findAndCountAll(condition);
    return { page, count, rows };
  }

  ZhirenInvestment.add = async (data) => {
    try {
      //返回promise对象实力 instance 
      const res = await ZhirenInvestment.create(data);
      //从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
      return res.id;
    } catch (error) {
      ctx.status = 500;
      throw (error);
    }
  }

  ZhirenInvestment.edit = async (data) => {
    const where = data.where;
    const params = data.params;
    ZhirenInvestment.update(params, {
      where: where
    }).catch(e => res.json({ status: 500, error: e }));
  }

  return ZhirenInvestment;

};
