
'use strict';

const Service = require('egg').Service;
const moment = require('moment');

const MODE = [
  {
    id: 1,
    name: '直播',
    value: 1,
  }, {
    id: 2,
    name: '录播',
    value: 2,
  }, {
    id: 3,
    name: '直播+回放',
    value: 3,
  }, {
    id: 0,
    name: '全部',
    value: 0,
  },
];

const PRICE_TYPE = [
  {
    id: 1,
    name: '低价体验课',
    value: 1,
  }, {
    id: 2,
    name: '公益免费课',
    value: 2,
  }, {
    id: 3,
    name: '正价课',
    value: 3,
  }, {
    id: 0,
    name: '全部',
    value: 0,
  },
];

class OptionService extends Service {
  async getOptions() {
    const { ctx } = this;
    // 分类
    const categoryList = await ctx.classModel.V5.CourseV5Category.findAll({ where: { type: 1, status: 1, is_deleted: 0 }, order: [[ 'sort', 'asc' ]], attributes: [ 'id', 'name' ], raw: true });
    categoryList.forEach(e => {
      e.value = e.id;
    });
    categoryList.push({ id: 0, name: '全部', value: 0 });
    // 年龄段
    const ageList = await ctx.classModel.V5.CourseV5Age.findAll({ where: { status: 1, is_deleted: 0 }, order: [[ 'sort', 'asc' ]], attributes: [ 'id', 'name' ], raw: true });
    ageList.forEach(e => {
      e.value = e.id;
    });
    ageList.push({ id: 0, name: '全部', value: 0 });
    // // 课程班型
    // const typeList = await ctx.classModel.V5.CourseV5Type.findAll({ where: { status: 1, is_deleted: 0 }, order: [ ['sort', 'asc'] ], attributes: [ 'id', 'name' ], raw: true });
    // typeList.forEach(e => {
    //   e.value = e.id;
    // });
    // typeList.push({ id: 0, name: '全部', value: 0 });
    // // 授课频次
    // const frequencyList = await ctx.classModel.V5.CourseV5Frequency.findAll({ where: { status: 1, is_deleted: 0 }, order: [ ['sort', 'asc'] ], attributes: [ 'id', 'name' ], raw: true });
    // frequencyList.forEach(e => {
    //   e.value = e.id;
    // });
    // frequencyList.push({ id: 0, name: '全部', value: 0 });

    const options = [
      { title: '所在班级', value: ageList, alias: 'age' },
      { title: '科目类型', value: categoryList, alias: 'category' },
      { title: '课程状态', value: MODE, alias: 'mode' },
      { title: '课程类型', value: PRICE_TYPE, alias: 'price_type' },
    ];

    const ret = {
      list: options,
    };
    return ret;
  }

  async getBannerList(alias) {
    const { ctx } = this;
    const bannerType = await ctx.classModel.V5.CourseBannerType.findOne({ where: { alias, status: 1, is_deleted: 0 }, row: true });
    if (ctx.isEmpty(bannerType)) {
      ctx.failed('数据不存在');
    }

    const banners = await ctx.classModel.V5.CourseBanner.findAll({ where: { type_id: bannerType.id, status: 1, is_deleted: 0 }, order: [[ 'sort', 'asc' ]], row: true });

    const results = [];
    for (const v of banners) {
      results.push({
        id: v.id,
        title: v.title,
        url: v.url,
        link: v.link,
        created_time: v.created_time,
      });
    }
    const ret = {
      list: results,
    };

    return ret;
  }


  // 获取分类
  async getCategoryList(input) {
    const { ctx } = this;
    const parentId = Number(input.parent_id) || 0;
    const type = Number(input.type) || 1;

    const filter = { where: { type, is_deleted: 0, status: 1 }, order: [[ 'sort', 'asc' ], [ 'id', 'asc' ]] };
    if (type === 2) {
      filter.where.parent_id = parentId;
    }

    const categoryList = await ctx.classModel.V5.CourseV5Category.findAll(filter);

    const results = [];
    for (const v of categoryList) {
      results.push({
        id: v.id,
        type: v.type,
        parent_id: v.parent_id,
        name: v.name,
        selected_icon: v.selected_icon,
        unselected_icon: v.unselected_icon,
        is_open: v.is_open,
        url: v.url,
        sort: v.sort,
      });
    }

    const ret = {
      list: results,
    };

    return ret;
  }


  // 获取反馈类型列表
  async getFeedbackTypeList() {
    const ret = {
      list: [
        { id: 1, name: '使用疑问' },
        { id: 2, name: '功能故障' },
        { id: 3, name: '数据错误' },
        { id: 4, name: '投诉' },
        { id: 5, name: '提建议' },
      ],
    };

    return ret;
  }

  // 提交反馈
  async addFeedback(input) {
    const { ctx } = this;

    const data = {
      user_uuid: ctx.userUuid,
      type: input.type,
      content: input.content,
      images: input.images,
      status: 1,
      is_deleted: 0,
      created_time: moment().format('YYYY-MM-DD HH:mm:ss'),
    };

    await ctx.classModel.V5.CourseFeedback.create(data);

    return { result: true };
  }
}

module.exports = OptionService;
