'use strict';

const Controller = require('egg').Controller;

class OptionController extends Controller {
  async getOptions() {

    const { ctx } = this;
    const ret = await ctx.service.course.v5.option.getOptions();

    ctx.success(ret);
  }

  async getBannerList() {
    const { ctx, service } = this;
    const queryParams = ctx.request.query;
    if (ctx.isEmpty(queryParams.alias)) {
      ctx.failed('alias is empty');
    }
    const ret = await service.course.v5.option.getBannerList(queryParams.alias);

    ctx.success(ret);
  }

  // 获取分类列表
  async getCategoryList() {
    const { ctx, service } = this;
    const queryParams = ctx.request.query;

    const ret = await service.course.v5.option.getCategoryList(queryParams);
    ctx.success(ret);
  }

  // 获取反馈类型列表
  async getFeedbackTypeList() {
    const { ctx, service } = this;
    const ret = await service.course.v5.option.getFeedbackTypeList();

    ctx.success(ret);
  }

  // 上传反馈内容
  async addFeedback() {
    const { ctx, service } = this;
    const params = ctx.request.body;

    if (ctx.isEmpty(params) || ctx.isEmpty(params.type)) {
      ctx.failed('type is empty');
    }
    if (ctx.isEmpty(params) || ctx.isEmpty(params.content)) {
      ctx.failed('content is empty');
    }

    const ret = await service.course.v5.option.addFeedback(params);
    ctx.success(ret);
  }

  // 获取分类年龄提示
  async getCategoryTip() {
    const { ctx, service } = this;
    const queryParams = ctx.request.query;

    if (ctx.isEmpty(queryParams) || ctx.isEmpty(queryParams.cat_id)) {
      ctx.failed('cat_id is empty');
    }

    const ret = await service.course.v5.option.getCategoryTip(queryParams);
    ctx.success(ret);
  }
}

module.exports = OptionController;
