'use strict';

const Controller = require('egg').Controller;

class InstitutionController extends Controller {
  // 课程列表
  async getClassList() {

    const { ctx } = this;
    const queryParams = ctx.request.query;
    const ret = await ctx.service.course.v5.institution.getClassList(queryParams);

    ctx.success(ret);
  }

  // 课程详情
  async getClassInfo() {

    const { ctx } = this;
    const class_id = ctx.params.class_id;
    if (!class_id) {
      ctx.failed('error class_id');
    }
    const ret = await ctx.service.course.v5.institution.getClassInfo(class_id);

    ctx.success(ret);
  }
}

module.exports = InstitutionController;
