'use strict';


const moment = require('moment');

module.exports = app => {
  const { INTEGER, DATE } = app.Sequelize;

  const CourseV5ClassToScore = app.classModel.define('course_v5_class_to_score', {
    id: {
      type: INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    class_id: INTEGER,
    score_id: INTEGER,
    status: INTEGER,
    is_deleted: INTEGER,
    created_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('created_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
    updated_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('updated_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
  }, {
    timestamps: false,
    tableName: 'course_v5_class_to_score',
  });

  return CourseV5ClassToScore;

};
