'use strict';

const Controller = require('egg').Controller;

class AbroadHouseController extends Controller {

    /**
     * 获取海外房列表
     */
    async list() {
        const { ctx } = this;
        let inputParams = ctx.request.body;
        const rule = {
            name: { type: 'string', required: false },
        };
        ctx.validate(rule, inputParams);
        let ret = await ctx.service.house.v2.abroadHouse.abroadHouseList(inputParams);
        ctx.success(ret);
    }


}

module.exports = AbroadHouseController;
