'use strict';

const Controller = require('egg').Controller;
const uuidv4 = require('uuid/v4');
class UserController extends Controller {


    async auth() {

        const { ctx, app } = this;
        const code = ctx.request.body.code = '123123sfdsf';
        if (!code) {
            ctx.failed('error code');
        }
        const wx_auth_ret = await ctx.service.course.user.requestWxAuth(code);
        const openid = wx_auth_ret.openid;
        // const session_key = wx_auth_ret.session_key;
        let user = ctx.classModel.CourseUser.one({ where: { openid, is_deleted: 0 } });
        if (!user || !user.uuid) {
            const uuid = uuidv4();
            user = await ctx.classModel.CourseUser.add({ uuid, openid });
        }
        const user_uuid = user.uuid;
        const key = 'course_user_session_' + user_uuid;
        await app.memcache.set(key, { user_uuid, openid }, 86400);
        const token = ctx.helper.md5(openid + user_uuid + 'jbwl');
        ctx.set('Session_Id', key);
        ctx.set('token', token);

        const result = { user_uuid };
        ctx.success({ result });

    }

    async registerUserInfo() {

        const { ctx } = this;
        const uuid = ctx.userUuid;
        const input_params = ctx.request.body;
        const { avatar, nickname, province, country, sex, city } = input_params;
        const user = ctx.classModel.CourseUser.one({ where: { uuid } });
        await ctx.classModel.CourseUser.edit({ params: { avatar, nickname, sex }, where: { uuid } });
        let bindphone = 0;
        if (user.phone) {
            bindphone = 1;
        }
        const result = { bindphone };

        ctx.success({ result });
    }



    async verify_auth() {

        const { ctx } = this;

        const headers = ctx.request.headers;

        ctx.success({ headers });
    }
    /**
     * 
     */
    async getBabyInfo() {

        const { ctx } = this;
        const result = await ctx.service.course.user.getBabyInfo();

        ctx.success({ result });
    }

    async saveBabyInfo() {

        const { ctx } = this;
        const input_params = ctx.request.body;
        const result = await ctx.service.course.user.saveBabyInfo(input_params);

        ctx.success({ result });
    }

    async delBabyInfo() {

        const { ctx } = this;
        const result = await ctx.service.course.user.delBabyInfo();

        ctx.success({ result });
    }


    async getCollectInstitutions() {

        const { ctx } = this;
        const input_params = ctx.request.body;
        const result = await ctx.service.course.user.getCollectInstitutions(input_params);

        ctx.success({ result });
    }


    async collectInstitution() {

        const { ctx } = this;
        const institution_id = ctx.request.body.institution_id;
        if (!institution_id) {
            ctx.failed('error institution_id');
        }
        const result = await ctx.service.course.user.collectInstitution(institution_id);

        ctx.success({ result });
    }




}

module.exports = UserController;
