'use strict';
module.exports = app => {
    const { INTEGER, TEXT } = app.Sequelize;

    const HouseSupplyDemand = app.blockModel.define('house_supply_demand', {
        id: {
            type: INTEGER,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true,
        },
        supply_demand_json: {
            type: TEXT,
            allowNull: true,
            field: 'supply_demand_json',
            get() {
                const supply_demand_json = this.getDataValue('supply_demand_json');
                if (supply_demand_json) {
                    try {
                        return JSON.parse(supply_demand_json);
                    } catch (error) {
                        return [];
                    }
                }
                return [];
            },
        },
    }, {
            timestamps: false,
            tableName: 'house_supply_demand',
            freezeTableName: true,
        });

    HouseSupplyDemand.one = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        return await HouseSupplyDemand.findOne({
            attributes: attributes,
            where: where,
        });
    }


    HouseSupplyDemand.all = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        return await HouseSupplyDemand.findAll({
            attributes: attributes,
            where: where,
        });
    }

    HouseSupplyDemand.list = async (data = {}) => {
        const limit = data.limit ? data.limit : 10;
        const page = data.page ? data.page : 1;
        const order = data.order ? data.order : [];
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const condition = {
            offset: (page - 1) * limit,
            limit,
            where: where,
            order: order,
            attributes: attributes,
        };

        const { count, rows } = await HouseSupplyDemand.findAndCountAll(condition);
        return { page, count, rows };
    }

    HouseSupplyDemand.add = async (data) => {
        try {
            //返回promise对象实力 instance 
            const res = await HouseSupplyDemand.create(data);
            //从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
            return res.id;
        } catch (error) {
            ctx.status = 500;
            throw (error);
        }
    }

    HouseSupplyDemand.edit = async (data) => {
        const where = data.where;
        const params = data.params;
        HouseSupplyDemand.update(params, {
            where: where
        }).catch(e => res.json({ status: 500, error: e }));
    }

    return HouseSupplyDemand;

};
