'use strict';

const Controller = require('egg').Controller;

class RentalHouseController extends Controller {

  //租房首页信息
  async home() {

    const { ctx } = this;
    const input_params = ctx.query;

    const city_code = input_params.city_code ? input_params.city_code : 330100;
    //banners
    const headers = {
      cookie: ctx.request.headers.cookie
    }

    const banners_result = await ctx.helper.send_request(this.config.NODE_BASE_URL + '/51app/api/block/all', { alias: '51fangc_rental_home_banners' }, { method: 'GET', dataType: 'json', headers: headers });
    let banners = [];
    if (banners_result.status === 200) {
      banners = banners_result.data.results;
    }
    const developers = await ctx.service.house.v2.option.getDevelopers(city_code);//品牌信息

    ctx.success({ banners, developers });
  }

  //租房列表
  async getRentalHouses() {

    const { ctx } = this;
    const input_params = ctx.request.body;

    const rule = {
      brand: { type: 'string', required: false },//品牌
      area_code: { type: 'object', required: false },//区域
      price: { type: 'object', required: false },//价格
      house_type: { type: 'string', required: false },//房型
      name: { type: 'string', required: false },//楼盘名称
      page: { type: 'string', required: false },
      page_size: { type: 'string', required: false },
    };
    ctx.validate(rule, input_params);
    const ret = await ctx.service.house.v2.rentalHouse.getRentalHousesByFilter(input_params);
    ctx.success({ input_params, results: ret.results, count: ret.count });
  }

  //租房详情
  async getRentalHouse() {
    const { ctx } = this;
    const input_params = ctx.params;
    if (!input_params.rental_house_id) {
      ctx.failed('rental_house_id error');
    }
    const rental_house_id = input_params.rental_house_id;
    const ret = await ctx.service.house.v2.rentalHouse.getRentalHouse(rental_house_id);
    ctx.success(ret);
  }

  //推荐楼盘
  async getRecommendRentalHouses() {

    const { ctx } = this;
    const input_params = ctx.query;
    const results = await ctx.service.house.v2.rentalHouse.getRecommendRentalHouses(input_params);

    ctx.success({ results });
}

}

module.exports = RentalHouseController;
