'use strict';

module.exports = app => {
  const router = app.router.namespace(app.config.projectRootPath + '/course');
  const loginAuth = app.middleware.loginAuth({ type: 'new' });// 登录中间件
  const miniAuth = app.middleware.miniAuth();// 因为不跟现有的用户中心系统，所以使用单独的登录中间件

  router.get('third', '/options', 'course.option.getOptions');// 筛选项
  router.post('third', '/address', miniAuth, 'course.location.getAddress');// 根据经纬度或ip获取地理位置信息
  router.post('third', '/institutions', miniAuth, 'course.institution.institutionList');// 机构列表
  router.get('third', '/institutions', miniAuth, 'course.institution.institutionList');// 机构列表
  router.get('third', '/institution/:institution_id/:area_id', miniAuth, 'course.institution.institutionInfo');// 机构详情
  router.post('third', '/classes', miniAuth, 'course.institution.classList');// 课程列表
  router.get('third', '/classes', miniAuth, 'course.institution.classList');// 课程列表
  router.get('third', '/class/:class_id', miniAuth, 'course.institution.classInfo');// 课程详情
  router.post('third', '/teachers', miniAuth, 'course.institution.teacherList');// 老师列表
  router.get('third', '/teachers', miniAuth, 'course.institution.teacherList');// 老师详情
  router.get('third', '/teacher/:teacher_id', miniAuth, 'course.institution.teacherInfo');// 老师详情

  router.post('third', '/user/auth', 'course.user.auth');// 微信授权登录
  router.post('third', '/user/register_user', miniAuth, 'course.user.registerUserInfo');// 授权后注册用户

  router.get('third', '/user/baby', miniAuth, 'course.user.getBabyInfo');// 获取baby信息
  router.post('third', '/user/baby', miniAuth, 'course.user.saveBabyInfo');// 保存baby信息
  router.delete('third', '/user/baby', miniAuth, 'course.user.delBabyInfo');// 删除baby信息

  router.get('third', '/user/collection/institution', miniAuth, 'course.user.getCollectInstitutions');// 收藏的机构列表
  router.post('third', '/user/collection/institution', miniAuth, 'course.user.collectInstitution');// 收藏机构
  router.delete('third', '/user/collection/institution', miniAuth, 'course.user.delCollectInstitution');// 取消收藏机构

  router.get('third', '/wechat/callbackAction', 'course.wechat.check');
  router.post('third', '/wechat/callbackAction', 'course.wechat.callbackAction');
  router.post('third', '/wechat/test', 'course.wechat.test');


  // 版本二
  router.get('third', '/sub/cats', 'course.institutionSub.getCats');// 分类
  router.get('third', '/sub/options', 'course.optionSub.getOptions');// 筛选项
  router.get('third', '/sub/banners', 'course.optionSub.getBanners');// banner
  router.post('third', '/sub/address', miniAuth, 'course.location.getAddress');// 根据经纬度或ip获取地理位置信息
  router.get('third', '/sub/institutions', miniAuth, 'course.institutionSub.institutionList');// 机构列表
  router.get('third', '/sub/institution/:institution_id', miniAuth, 'course.institutionSub.institutionInfo');// 机构详情
  router.post('third', '/sub/classes', miniAuth, 'course.institution.classList');// 课程列表
  router.get('third', '/sub/classes', miniAuth, 'course.institution.classList');// 课程列表
  router.get('third', '/sub/class/:class_id', miniAuth, 'course.institution.classInfo');// 课程详情
  router.post('third', '/sub/teachers', miniAuth, 'course.institution.teacherList');// 老师列表
  router.get('third', '/sub/teachers', miniAuth, 'course.institution.teacherList');// 老师详情
  router.get('third', '/sub/teacher/:teacher_id', miniAuth, 'course.institution.teacherInfo');// 老师详情

  router.post('third', '/sub/user/auth', 'course.user.auth');// 微信授权登录
  router.post('third', '/sub/user/register_user', miniAuth, 'course.user.registerUserInfo');// 授权后注册用户

  router.get('third', '/sub/user/baby', miniAuth, 'course.user.getBabyInfo');// 获取baby信息
  router.post('third', '/sub/user/baby', miniAuth, 'course.user.saveBabyInfo');// 保存baby信息
  router.delete('third', '/sub/user/baby', miniAuth, 'course.user.delBabyInfo');// 删除baby信息

  router.get('third', '/sub/user/collection/institution', miniAuth, 'course.user.getCollectInstitutions');// 收藏的机构列表
  router.post('third', '/sub/user/collection/institution', miniAuth, 'course.user.collectInstitution');// 收藏机构
  router.delete('third', '/sub/user/collection/institution', miniAuth, 'course.user.delCollectInstitution');// 取消收藏机构

  router.get('third', '/sub/wechat/callbackAction', 'course.wechat.check');
  router.post('third', '/sub/wechat/callbackAction', 'course.wechat.callbackAction');
  router.post('third', '/sub/wechat/test', 'course.wechat.test');

  router.get('third', '/sub/comments', miniAuth, 'course.institutionSub.getComments');// 评论列表
  router.get('third', '/sub/search/hot', miniAuth, 'course.institutionSub.getHotSearch');// 热搜
  router.get('third', '/sub/search/suggest', miniAuth, 'course.institutionSub.getSuggestSearch');//搜索联想
  router.get('third', '/sub/search', miniAuth, 'course.institutionSub.search');// 搜索
  router.get('third', '/sub/user/search', miniAuth, 'course.institutionSub.getUserSearch');// 用户搜索历史
  router.delete('third', '/sub/user/search', miniAuth, 'course.institutionSub.deleteUserSearch');//清空用户搜索记录

};
