'use strict';

const Controller = require('egg').Controller;
class ProductController extends Controller {

    // 筛选项列表
    async getOptionProducts() {

        const { ctx } = this;
        const type = ctx.params.type || 'credit';
        let suit_options;
        if(type == 'loan'){
            suit_options = await ctx.service.gjj.product.getLoanChannelSuitOptions();
        }
        const keys = ctx.query.keys ? eval(ctx.query.keys) : [];
        const results = await ctx.service.gjj.product.getRecommendOptions(type, keys);
        if(suit_options){
            results.unshift(suit_options);
        }
        const credit_loans = await ctx.service.gjj.product.getAllProductsByType(1);
        const common_loans = await ctx.service.gjj.product.getAllProductsByType(4);
        ctx.success({ results:results, credit_loans:credit_loans, common_loans: common_loans });
    }
}
module.exports = ProductController;
