'use strict';

const Controller = require('egg').Controller;

class OptionController extends Controller {

  /**
     * 筛选项
     */
  async getOptions() {

    const { ctx } = this;
    const results = await ctx.service.course.v5.option.getOptions();

    ctx.success({ results });
  }

  async getBannerList() {
    const { ctx, service } = this;
    const queryParams = ctx.request.query;
    if (ctx.isEmpty(queryParams.alias)) {
      ctx.failed('alias is empty');
    }
    const ret = await service.course.v5.option.getBannerList(queryParams.alias);

    ctx.success(ret);
  }

  // 获取分类列表
  async getCategoryList() {
    const { ctx, service } = this;
    const queryParams = ctx.request.query;

    const ret = await service.course.v5.option.getCategoryList(queryParams);
    ctx.success(ret);
  }
}

module.exports = OptionController;
