
'use strict';

const Service = require('egg').Service;
const R = require('ramda');
const _ = require('lodash');
const moment = require('moment');
const sequelize = require('sequelize');

class InstitutionSubService extends Service {
  // 课程列表
  async getClassList(input) {
    const { ctx } = this;
    const page = Number(input.page) || 1;
    const page_size = Number(input.page_size) || 10;
    const offset = (page - 1) * page_size;
    const attributes = [ 'id', 'institution_id', 'name', 'logo', 'age', 'price', 'price_type', 'mode', 'time', 'class_amount', 'multi_classes', 'cycle', 'description', 'sort' ];
    const filter = { where: { status: 1, is_deleted: 0 }, order: [[ 'sort', 'asc' ], [ 'id', 'desc' ]], page_size, offset, attributes };
    let filterIds = [];
    let flag = false;
    // 年龄筛选
    if (!ctx.isEmpty(input.age)) {
      const filterByAge = await ctx.classModel.CourseV5ClassToAge.findAll({ where: { age_id: input.age, status: 1, is_deleted: 0 }, attributes: [ 'class_id' ] });
      filterIds = R.pluck('class_id', filterByAge);
      flag = true;
    }
    // 科目类型
    if (!ctx.isEmpty(input.cat_id)) {
      const filterByCategory = await ctx.classModel.CourseV5ClassToCat.findAll({ where: { cat_id: input.cate_id, status: 1, is_deleted: 0 }, attributes: [ 'class_id' ] });
      filterIds = flag ? _.intersection(filterIds, R.pluck('class_id', filterByCategory)) : R.pluck('class_id', filterByCategory);
      flag = true;
    }
    // 课程状态
    if (!ctx.isEmpty(input.mode)) {
      filter.where.mode = input.mode;
    }
    // 课程类型
    if (!ctx.isEmpty(input.price_type)) {
      filter.where.price_type = input.price_type;
    }
    if (flag) {
      filter.where.id = { $in: filterIds };
    }

    const classList = await ctx.classModel.CourseV5Class.findAndCountAll(filter);

    // 用户收藏的课程
    const userCollection = await ctx.classModel.V5.CourseUserCollection.findAll({ where: { user_uuid: ctx.userUuid, is_deleted: 0, type: 3 }, raw: true });
    const collectedIds = R.pluck('type_id', userCollection);
    for (const i in classList.rows) {
      classList.rows[i].is_collected = collectedIds.includes(classList.rows[i].id) ? 1 : 0;
    }

    const ret = {
      list: classList.rows,
      total_count: classList.count,
      page,
      page_size,
    };
    return ret;
  }


  // 课程详情
  async getClassInfo(id) {
    const { ctx } = this;
    const attributes = [ 'id', 'institution_id', 'name', 'logo', 'age', 'price', 'price_type', 'mode', 'time', 'class_amount', 'multi_classes', 'cycle', 'description', 'sort' ];
    const classInfo = await ctx.classModel.V5.CourseV5Class.findOne({ where: { id, status: 1, is_deleted: 0 }, attributes, raw: true });
    if (ctx.isEmpty(classInfo)) {
      ctx.failed('数据不存在');
    }


    const isCollected = await ctx.classModel.V5.CourseUserCollection.findOne({ where: { user_uuid: ctx.userUuid, type: 3, type_id: id, is_deleted: 0 } });
    classInfo.is_collected = ctx.isEmpty(isCollected) ? 0 : 1;

    // 额外字段
    const classColumns = await ctx.classModel.V5.CourseV5ClassToColumn.findAll({ where: { class_id: id, status: 1, is_deleted: 0 } });
    let columnList = await ctx.classModel.V5.CourseV5Column.findAll({ where: { id: { $in: R.pluck('column_id', classColumns) }, status: 1, is_deleted: 0 }, attributes: [ 'name' ] });
    columnList = _.groupBy(columnList, 'id');

    const columns = [];
    for (const v of classColumns) {
      if (!ctx.isEmpty(columnList[v.column_id])) {
        columns.push({
          id: v.column_id,
          key: columnList[v.column_id][0].name,
          value: v.value,
        });
      }
    }
    classInfo.columns = columns;

    return classInfo;
  }

  // 用户收藏课程列表
  async getUserCollectedClasses(input) {
    const { ctx } = this;
    const userUuid = ctx.userUuid;

    const userCollection = await ctx.classModel.V5.CourseUserCollection.findAll({ where: { user_uuid: userUuid, is_deleted: 0, type: 2 }, raw: true });
    const classIds = R.pluck('type_id', userCollection);
    input.classIds = classIds;

    const ret = await this.getClasses(input);
    return ret;
  }

  //
}

module.exports = InstitutionSubService;
