
'use strict';

const Service = require('egg').Service;
const R = require('ramda');
class HouseImageService extends Service {

    /**
     * 获取图片相册
     * @param {object} condition {type: XX, connect_id: XX}
     * @param {object} elements [id, path, ...]//需要筛选出的元素
     */
    async getAll(condition, elements = []) {

        const { ctx } = this;
        const { type, connect_id } = condition;
        if (type === undefined || !connect_id) {
            return [];
        }
        let ret = await ctx.realestateModel.HouseImage.all({ where: { status: 'online', valid: 1, type: type, connect_id: connect_id } });
        if (Array.isArray(elements) && elements.length !== 0) {
            ret = R.project(elements)(ret);
        }
        return ret;
    }
}

module.exports = HouseImageService;
