
'use strict';

const Service = require('egg').Service;
const moment = require('moment');
const _ = require('lodash');

class CommonService extends Service {

    /**
     * 
     * @param {*} type 黑名单00通话01
     * @param {*} id 报告自增编号
     */
    async getReportNo(type, id) {
        let prefix = '51GJJ' + moment().format('YYYYMMDD') + type;
        let suffix = String(Number(id) + 12580);
        if (suffix.length > 5) {
            let subStart = suffix.length - 5;
            suffix = suffix.substring(subStart, suffix.length + 1);
        }
        return prefix + suffix;
    }


}

module.exports = CommonService;
