'use strict';

module.exports = app => {
  const router = app.router.namespace(app.config.projectRootPath + '/course/back');
  const auth = app.middleware.backAuth();

  router.post('third', '/login', 'course.back.login');
  router.get('third', '/menu', auth, 'course.back.getMenuList');
  router.get('third', '/order', auth, 'course.back.getOrderList');
  router.get('third', '/redeem', auth, 'course.back.getRedeemCodeList');
  router.post('third', '/redeem', auth, 'course.back.addRedeemCode');
  router.get('third', '/class', auth, 'course.back.getClassList');
  router.get('third', '/export/order', auth, 'course.back.exportOrder');
  router.get('third', '/export/redeem', auth, 'course.back.exportRedeemCode');
  router.get('third', '/export/redeem/used', auth, 'course.back.exportUsedRedeemCode');
  router.get('third', '/redeem/used', auth, 'course.back.getUsedRedeemCodeList');
};
