'use strict';

const Controller = require('egg').Controller;

class InstitutionController extends Controller {

  // 机构列表
  async getInstitutions() {

    const { ctx } = this;
    const inputParams = ctx.request.query;
    const ret = await ctx.service.course.v4.institution.getInstitutions(inputParams);

    ctx.success(ret);
  }

  // 机构详情
  async getInstitution() {

    const { ctx } = this;
    let inputParams = ctx.params;
    const query = ctx.query;
    inputParams = Object.assign(inputParams, query);
    const result = await ctx.service.course.v4.institution.getInstitution(inputParams);

    ctx.success({ result });
  }

  // 课程列表
  async getClasses() {

    const { ctx } = this;
    const inputParams = ctx.request.query;
    const ret = await ctx.service.course.v4.institution.getClasses(inputParams);

    ctx.success(ret);
  }

  // 课程详情
  async getClass() {

    const { ctx } = this;
    const class_id = ctx.params.class_id;
    if (!class_id) {
      ctx.failed('error class_id');
    }
    const inputParams = ctx.request.query;
    inputParams.id = class_id;
    const ret = await ctx.service.course.v4.institution.getClass(inputParams);

    ctx.success(ret);
  }

  // 老师列表
  async getTeachers() {

    const { ctx } = this;
    const inputParams = ctx.request.query;
    if (ctx.isEmpty(inputParams.institution_id)) {
      ctx.failed('institution_id is empty');
    }
    const ret = await ctx.service.course.v4.institution.getTeachers(inputParams);

    ctx.success(ret);
  }

  // 老师详情
  async getTeacher() {

    const { ctx } = this;
    const teacher_id = ctx.params.teacher_id;
    if (!teacher_id) {
      ctx.failed('error teacher_id');
    }
    const ret = await ctx.service.course.v4.institution.getTeacher(teacher_id);

    ctx.success(ret);
  }

  // 获取分类
  async getCats() {
    const { ctx } = this;

    const ret = await ctx.service.course.v4.institution.getCats();

    ctx.success(ret);
  }

  // 搜索
  async search() {

    const { ctx } = this;
    const inputParams = ctx.request.query;
    const ret = await ctx.service.course.v4.institution.search(inputParams);

    ctx.success(ret);
  }

  // 用户搜索历史
  async getUserSearch() {
    const { ctx, service } = this;
    const ret = await service.course.v4.institution.getUserSearch();

    ctx.success(ret);
  }

  // 获取热搜
  async getHotSearch() {
    const { ctx, service } = this;
    const ret = await service.course.v4.institution.getHotSearch();

    ctx.success(ret);
  }

  // 删除用户搜索历史
  async deleteUserSearch() {
    const { ctx, service } = this;
    await service.course.v4.institution.deleteUserSearch();

    ctx.success();
  }

  // 评论列表
  async getComments() {
    const { ctx, service } = this;
    const inputParams = ctx.request.query;
    const ret = await service.course.v4.institution.getComments(inputParams);

    ctx.success(ret);
  }

  // 搜索联想
  async getSuggestSearch() {
    const { ctx, service } = this;
    const inputParams = ctx.request.query;
    const ret = await service.course.v4.institution.getSuggestSearch(inputParams);

    ctx.success(ret);
  }

  // 用户收藏机构列表
  async getUserCollectedInstitutions() {
    const { ctx, service } = this;
    const inputParams = ctx.request.query;
    const ret = await service.course.v4.institution.getUserCollectedInstitutions(inputParams);

    ctx.success(ret);
  }

  // 用户收藏课程列表
  async getUserCollectedClasses() {
    const { ctx, service } = this;
    const inputParams = ctx.request.query;
    const ret = await service.course.v4.institution.getUserCollectedClasses(inputParams);

    ctx.success(ret);
  }

  // 根据分类获取选课指南
  async getArticlesByCat() {
    const { ctx, service } = this;
    const inputParams = ctx.request.query;
    if (ctx.isEmpty(inputParams) || ctx.isEmpty(inputParams.cat_id)) {
      ctx.failed('cat_id is empty');
    }

    const ret = await service.course.v4.institution.getArticlesByCat(inputParams);
    ctx.success(ret);
  }

  // 获取选课指南详情
  async getArticle() {
    const { ctx, service } = this;
    const inputParams = ctx.params;
    if (ctx.isEmpty(inputParams) || ctx.isEmpty(inputParams.id)) {
      ctx.failed('article_id is empty');
    }

    const ret = await service.course.v4.institution.getArticle(Number(inputParams.id));
    ctx.success(ret);
  }

  // 点赞
  async like() {
    const { ctx, service } = this;
    const inputParams = ctx.request.body;
    if (ctx.isEmpty(inputParams) || ctx.isEmpty(inputParams.type) || ctx.isEmpty(inputParams.type_id)) {
      ctx.failed('参数错误');
    }

    const ret = await service.course.v4.institution.like(inputParams);
    ctx.success(ret);
  }

  // 取消点赞
  async unlike() {
    const { ctx, service } = this;
    const inputParams = ctx.request.body;
    if (ctx.isEmpty(inputParams) || ctx.isEmpty(inputParams.type) || ctx.isEmpty(inputParams.type_id)) {
      ctx.failed('参数错误');
    }

    const ret = await service.course.v4.institution.unlike(inputParams);
    ctx.success(ret);
  }

  // 获取推荐选课指南
  async getArticlesByRecommend() {
    const { ctx, service } = this;
    const inputParams = ctx.request.query;

    const ret = await service.course.v4.institution.getArticlesByRecommend(inputParams);
    ctx.success(ret);
  }
}

module.exports = InstitutionController;
