'use strict';
module.exports = app => {
  const { STRING, INTEGER } = app.Sequelize;

  const HouseDistrict = app.blockModel.define('house_district', {
    id: {
      type: INTEGER,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    name: STRING,
    spell: STRING,
    city_id: INTEGER,
  }, {
    timestamps: false,
    tableName: 'house_district',
    freezeTableName: true,
  });

  HouseDistrict.one = async (data) => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    return await HouseDistrict.findOne({
      attributes: attributes,
      where : where,
    });
  }


  HouseDistrict.all = async (data) => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    return await HouseDistrict.findAll({
      attributes: attributes,
      where : where,
    });
  }

  HouseDistrict.list = async (data = {}) => {
    const limit = data.limit ? data.limit : 10;
    const page = data.page ? data.page : 1;
    const order = data.order ? data.order : [];
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    const condition = {
      offset: (page - 1) * limit,
      limit,
      where: where,
      order: order,
      attributes: attributes,
    };

    const { count, rows } =  await HouseDistrict.findAndCountAll(condition);
    return { page, count, rows };
  }

  HouseDistrict.add = async (data) => {
    try {
      //返回promise对象实力 instance 
      const res = await HouseDistrict.create(data);
      //从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
      return res.id;  
    } catch(error) {
      ctx.status = 500;
      throw (error);
    }    
  }

  HouseDistrict.edit = async (data) => {
    const where = data.where;
    const params = data.params;
    HouseDistrict.update(params, {
      where: where
    }).catch( e => res.json({status: 500, error: e}));
  }

  return HouseDistrict;

};
