'use strict';
module.exports = app => {
  const { STRING, INTEGER } = app.Sequelize;

  const HouseInvestPlan = app.blockModel.define('house_invest_map', {
    id: {
      type: INTEGER,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    alias: STRING,
    condition: STRING,
    period: STRING,
    items: STRING,
    status: INTEGER,
    remark: STRING,
    valid: INTEGER,
  }, {
    timestamps: false,
    tableName: 'house_invest_map',
    freezeTableName: true,
  });

  HouseInvestPlan.one = async (data) => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    return await HouseInvestPlan.findOne({
      attributes: attributes,
      where : where,
    });
  }


  HouseInvestPlan.all = async (data) => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    return await HouseInvestPlan.findAll({
      attributes: attributes,
      where : where,
    });
  }

  HouseInvestPlan.list = async (data = {}) => {
    const limit = data.limit ? data.limit : 10;
    const page = data.page ? data.page : 1;
    const order = data.order ? data.order : [];
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    const condition = {
      offset: (page - 1) * limit,
      limit,
      where: where,
      order: order,
      attributes: attributes,
    };

    const { count, rows } =  await HouseInvestPlan.findAndCountAll(condition);
    return { page, count, rows };
  }

  HouseInvestPlan.add = async (data) => {
    try {
      //返回promise对象实力 instance 
      const res = await HouseInvestPlan.create(data);
      //从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
      return res.id;  
    } catch(error) {
      ctx.status = 500;
      throw (error);
    }    
  }

  HouseInvestPlan.edit = async (data) => {
    const where = data.where;
    const params = data.params;
    HouseInvestPlan.update(params, {
      where: where
    }).catch( e => res.json({status: 500, error: e}));
  }

  return HouseInvestPlan;

};
