'use strict';

const moment = require('moment');

module.exports = app => {
  const { STRING, INTEGER, DATE, TEXT } = app.Sequelize;
  const Position = app.blockModel.define('position', {
    id: { type: INTEGER, primaryKey: true, autoIncrement: true },
    user_sid: INTEGER,
    type: STRING,
    state: INTEGER,
    status: STRING,
    // 注意，需要转成string
    created_time: {
      type: DATE,
      get() {
        const date = this.getDataValue('created_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
  }, {
    timestamps: false,
    tableName: 'position',
  });

  Position.one = async data => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    return await Position.findOne({
      attributes,
      where,
    });
  };


  Position.all = async data => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    return await Position.findAll({
      attributes,
      where,
    });
  };

  Position.list = async (data = {}) => {
    const limit = data.limit ? data.limit : 10;
    const page = data.page ? data.page : 1;
    const order = data.order ? data.order : [];
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    const condition = {
      offset: (page - 1) * limit,
      limit,
      where,
      order,
      attributes,
    };
    const { count, rows } = await Position.findAndCountAll(condition);
    return { page, count, rows };
  };

  Position.add = async data => {
    try {
      // 返回promise对象实力 instance
      const res = await Position.create(data);
      // 从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
      return res.id;
    } catch (error) {
      ctx.status = 500;
      throw (error);
    }
  };

  Position.edit = async data => {
    const where = data.where;
    const params = data.params;
    Position.update(params, {
      where,
    }).catch(e => res.json({ status: 500, error: e }));
  };

  return Position;

};
