
'use strict';

const Service = require('egg').Service;
const moment = require('moment');
const _ = require('lodash');

class OrderService extends Service {

    //历史订单
    async getHistoryOrders(order_type) {

        const { ctx } = this;

        const type_obj = {
            'blacklist': 1,
            'callrisk': 2,
        }

        const type = type_obj[order_type];

        const order_records = await ctx.prometheusModel.CreditOrder.all({ where: { type } });
        const worth_h = [];
        const worth_l = [];

        for (let i in order_records) {

            const order = await this.updateOrderState(order_records[i]);
            if (order.state === '已失效') continue;
            const is_expire = await this.checkOrderExpire(order);

            const apply = { phone: '15968762898', report_no: '51gjj201909050100001' };//TODO query apply
            const item = {
                order_id: order.id,
                order_no: order.order_no,
                report_id: apply.report_id,
                type: order_type,
                created_time: order.created_at,
                phone: apply.phone.replace(apply.phone.substring(3, 7), "****"),
                state: order.state,
                state_text: order.state === '已支付' ? '' : order.state,
            };
            if (is_expire) {
                worth_h.push(item);
            } else {
                worth_l.push(item);
            }
        }

        return { worth_h, worth_l }
    }

    //更新订单状态
    async updateOrderState(order) {

        const { ctx } = this;
        const { id, created_at, state, pay_status } = order;
        if (!id || !created_at || !state || typeof (pay_status) === 'undefined') {
            return order;
        }
        const expire_time = moment(created_at).valueOf() + 24 * 3600;
        const now_time = moment().valueOf();
        const state_time = moment().format('YYYY-MM-DD HH:mm:ss');
        if (expire_time < now_time && state === '待支付' && pay_status === 0) {
            const ret = await ctx.prometheusModel.CreditOrder.update({ state: '已失效', state_time: state_time }, { where: { id } });
            if (ret || ret[0]) {
                order.state = '已失效';
                order.state_time = state_time;
            }
        }
        return order;

    }

    //检查订单报告是否 还在规定的时间内 是否具有高价值 0：具有高价值 1：生成时间过长-低价值
    async checkOrderExpire(order) {

        const { ctx } = this;
        const { id, type, state_time, state, pay_status } = order;
        if (!id || !type || !state_time || !state || typeof (pay_status) === 'undefined') {
            return 0;
        }

        const worth_time = type === 1 ? 15 : 30;
        const expire_time = moment(state_time).valueOf() + worth_time * 86400;
        const now_time = moment().valueOf();
        if (pay_status === 1 && state === '已支付' && expire_time > now_time) {//还在规定的有效期内 高价值报告
            return 0;
        }

        return 1;
    }

    /**
     * 
     * @param {*} type 报告类型(黑名单1通话2)
     * @param {*} reportId 订单编号
     */
    async getReportValid(type, reportId) {
        const { ctx } = this;
        let valid = 0;
        if (![1, 2].includes(type)) {
            return valid;
        }
        let timeLine = (type === 1) ? 15 : 30;
        let orderFilter = {
            where: {
                report_id: reportId,
                type: type,
                valid: 1
            }
        };
        let orderInfo = await ctx.prometheusModel.CreditOrder.findOne(orderFilter);
        if (orderInfo != null) {
            if (orderInfo.state === '已支付' && moment(orderInfo.state_time).add(timeLine, 'days').format('YYYY-MM-DD HH:mm:ss') > moment().format('YYYY-MM-DD HH:mm:ss')) {
                valid = 1;
            }
        }
        return valid;
    }



}

module.exports = OrderService;
