'use strict';


const moment = require('moment');

module.exports = app => {
  const { STRING, INTEGER, DATE, DECIMAL, TEXT, ENUM } = app.Sequelize;

  const CourseCat = app.classModel.define('course_cat', {
    id: {
      type: INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    first_id: INTEGER,
    parent_id: INTEGER,
    level: INTEGER,
    name: STRING,
    image: STRING,
    color: STRING,
    tips: STRING,
    status: ENUM('offline', 'online'),
    is_deleted: INTEGER,
    created_at: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('created_at');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
    updated_at: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('updated_at');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
  }, {
    timestamps: false,
    tableName: 'course_cat',
  });

  CourseCat.one = async data => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    return await CourseCat.findOne({
      attributes,
      where,
    });
  };

  CourseCat.all = async data => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    const order = data.order ? data.order : [];
    return await CourseCat.findAll({
      attributes,
      where,
      order,
    });
  };

  CourseCat.list = async (data = {}) => {
    const limit = data.limit ? Number(data.limit) : 10;
    const page = data.page ? data.page : 1;
    const order = data.order ? data.order : [];
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    const condition = {
      offset: (page - 1) * limit,
      limit,
      where,
      order,
      attributes,
    };
    const { count, rows } = await CourseCat.findAndCountAll(condition);
    return { page, count, rows };
  };

  CourseCat.add = async data => {
    try {
      // 返回promise对象实力 instance
      const res = await CourseCat.create(data);
      // 从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
      return res.id;
    } catch (error) {
      throw (error);
    }
  };

  CourseCat.edit = async data => {
    const where = data.where;
    const params = data.params;
    try {
      const res = await CourseCat.update(params, { where });
      return res;
    } catch (error) {
      throw (error);
    }
  };

  return CourseCat;

};
