'use strict';

const moment = require('moment');

module.exports = app => {
    const { STRING, INTEGER, DATE } = app.Sequelize;

    const SysGuest = app.gjjModel.define('sys_guest', {
        sid: {
            type: INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        passport: {
            type: STRING,
            allowNull: false
        },
        place_cid: {
            type: INTEGER,
            allowNull: false
        },
    }, {
            timestamps: false,
            tableName: 'sys_guest',
        });

        SysGuest.one = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        return await SysGuest.findOne({
            attributes: attributes,
            where: where,
        });
    }

    return SysGuest;
};

