'use strict';
const Service = require('egg').Service;
const APPID = 'wx07a5f0ed5bdf4751';
const SECRET = 'a1b2d32b018988176181497bd74a0b7d';
const fs = require('fs');
const request = require('request');
const crypto = require('crypto');

class WechatService extends Service {
  async getAccessToken() {
    const { ctx } = this;
    const url = 'https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=' + APPID + '&secret=' + SECRET;

    // 先从redis中取
    let token = await this.app.memcache.get('wechat_course_v4_accessToken');
    if (ctx.isEmpty(token)) {
      const resp = await ctx.helper.send_request(url, {}, { method: 'GET' });
      if (resp.status === 200 && !ctx.isEmpty(resp.data) && !ctx.isEmpty(resp.data.access_token)) {
        token = resp.data.access_token;
        await this.app.memcache.set('wechat_course_v4_accessToken', token, resp.data.expires_in);
      }
    }

    return token;
  }

  async callbackAction() {
    const { ctx, app } = this;
    ctx.logger.info('course_wechat_v4_receive: ' + JSON.stringify(ctx.request.body));
    await this.sendMsg(ctx.request.body);
  }

  async sendMsg(data) {
    const { ctx } = this;
    ctx.logger.info('111');
    if (ctx.isEmpty(data) || ctx.isEmpty(data.MsgType)) {
      ctx.logger.info(JSON.stringify(data));
      return;
    }

    ctx.logger.info(data.MsgType);
    if (data.MsgType === 'miniprogrampage') {
      ctx.logger.info('------------miniprogrampage---------');
      await this.sendImage(data);
    } else if (data.MsgType === 'text') {
      ctx.logger.info('------------sendText------');
      await this.sendText(data);
    }

    return;
  }

  async sendText(data) {
    const { ctx } = this;

    if (ctx.isEmpty(data) || ctx.isEmpty(data.Content) || !data.Content.includes('在线课程编号:')) {
      ctx.logger.info(data.Content);
      ctx.logger.info(data.Content.includes('在线课程编号:'));
      return;
    }
    const id = data.Content.replace('在线课程编号:', '');
    const classInfo = await ctx.classModel.V4.CourseOnlineClass.findOne({ where: { id } });
    ctx.logger.info('course_v4: ' + JSON.stringify(classInfo));
    const content = ctx.isEmpty(classInfo) || ctx.isEmpty(classInfo.channel) ? '' : classInfo.channel;
    const token = await this.getAccessToken();
    const url = 'https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=' + token;
    const params = {
      access_token: token,
      touser: data.FromUserName,
      msgtype: 'text',
      text: { content },
    };
    ctx.logger.info('course_wechat_v4_param: ' + JSON.stringify(params));
    const resp = await ctx.helper.send_request(url, params, { method: 'POST' });
    ctx.logger.info('course_wechat_v4_resp: ' + JSON.stringify(resp));
    return;
  }

  async sendImage(data) {
    const { ctx, app } = this;

    if (ctx.isEmpty(data)) {
      return;
    }

    // 只有MsgType为miniprogrampage才发送
    if (ctx.isEmpty(data.MsgType) || data.MsgType !== 'miniprogrampage') {
      return;
    }

    let mediaId = null;//await this.app.memcache.get('course_wechat_v4_service_image_media_id');

    if (ctx.isEmpty(mediaId)) {
      const images = 'data:image/jpeg;base64,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';
      const image = images.replace(/^data:image\/\w+;base64,/, '');
      const imgBuffer = Buffer.from(image, 'base64');
      fs.writeFile('image.jpg', imgBuffer, function(err) {});
      const file = fs.createReadStream('image.jpg');
      const imageInfo = { media: file };
      mediaId = await this.uploadTempMedia(imageInfo);
      await this.app.memcache.set('course_wechat_v4_service_image_media_id', mediaId, 72 * 3600);
    }

    if (ctx.isEmpty(mediaId)) {
      return;
    }

    const token = await this.getAccessToken();
    const url = 'https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=' + token;
    const params = {
      access_token: token,
      touser: data.FromUserName,
      msgtype: 'image',
      image: { media_id: mediaId },
    };
    const resp = await ctx.helper.send_request(url, params, { method: 'POST' });
    ctx.logger.info('course_wechat_v4_resp: ' + JSON.stringify(resp));
    return;
  }

  async getTempMedia(mediaId) {
    const { ctx } = this;
    const url = 'https://api.weixin.qq.com/cgi-bin/media/get';

    const image = await this.app.memcache.get('course_wechat_v4_service_image');
    if (image) {
      return image;
    }

    const token = await this.getAccessToken();
    const params = {
      access_token: token,
      media_id: mediaId,
    };
    const resp = await ctx.helper.send_request(url, params, { method: 'GET' });

    let ret = '';
    if (resp.status === 200 && !ctx.isEmpty(resp.data) && resp.data.errCode === 0) {
      await this.app.memcache.set('course_wechat_v4_service_image', resp.data.buffer, 72 * 3600);
      ret = resp.data.buffer;
    }

    return ret;
  }

  /*
  把媒体文件上传到微信服务器。目前仅支持图片。用于发送客服消息或被动回复用户消息。
  type: 'image',
  media: {
    contentType: 'image/png',
    value: Buffer
  }
  */
  async uploadTempMedia(data) {
    const { ctx, app } = this;
    if (ctx.isEmpty(data)) {
      return;
    }
    const token = await this.getAccessToken();
    const url = 'https://api.weixin.qq.com/cgi-bin/media/upload?access_token=' + token + '&type=image';

    // if (resp.status === 200 && !ctx.isEmpty(resp.data) && resp.data.errCode === 0) {
    //     await this.app.memcache.set('course_wechat_v4_service_image_media_id', resp.data.mediaId, 72*3600);
    //     ret = resp.data.mediaId;
    // }

    const ret = await new Promise((resolve, reject) => {
      request.post({ url, formData: data }, function(error, response, body) {
        const resp = {
          statusCode: response.statusCode,
          body: response.body,

        };
        ctx.logger.info('course_wechat_v4_uploadTempMedia_resp: ' + JSON.stringify(resp));
        if (response.statusCode === 200) {
          const result = JSON.parse(body);
          resolve(result.media_id);
        } else {
          resolve('');
        }
      });
    });

    return ret;
  }

  // 解密
  async decodeData(encryptedData, iv) {
    const { ctx } = this;
    const userUuid = ctx.userUuid;
    const userInfo = await ctx.app.memcache.get('course_v4_user_session_' + userUuid);
    if (ctx.isEmpty(userInfo) || ctx.isEmpty(userInfo.session_key)) {
      ctx.failed('sessionKey不存在');
    }

    const sessionKey = new Buffer(userInfo.session_key, 'base64');

    // base64 decode
    encryptedData = new Buffer(encryptedData, 'base64');
    iv = new Buffer(iv, 'base64');

    try {
      // 解密
      const decipher = crypto.createDecipheriv('aes-128-cbc', sessionKey, iv);
      // 设置自动 padding 为 true，删除填充补位
      decipher.setAutoPadding(true);
      var decoded = decipher.update(encryptedData, 'binary', 'utf8');
      decoded += decipher.final('utf8');

      decoded = JSON.parse(decoded);

    } catch (err) {
      ctx.failed('Illegal Buffer');
    }

    return decoded;
  }
}

module.exports = WechatService;
