'use strict';


const moment = require('moment');

module.exports = app => {
  const { STRING, INTEGER, DATE } = app.Sequelize;

  const CourseV5UserVideo = app.classModel.define('course_v5_user_video', {
    id: {
      type: INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    user_uuid: STRING,
    class_id: INTEGER,
    video_id: INTEGER,
    created_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('created_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
    updated_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('updated_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
  }, {
    timestamps: false,
    tableName: 'course_v5_user_video',
  });

  return CourseV5UserVideo;

};
