
'use strict';

const Service = require('egg').Service;

class ToolService extends Service {

    //新房地图点位
    async getNewHouseMapPoint(area_code, level) {

        const { ctx } = this;
        let map_points = [];
        if (level == 1) {
            map_points = await ctx.blockModel.HouseNewHousePriceMap.all({ where: { pid: area_code } });
        } else {
            map_points = await ctx.blockModel.HouseNewHousePriceMap2.all({ where: { pid: area_code } });
        }

        if (!map_points || map_points.length === 0) {
            return [];//sdfsfsfs
        }

        const ret = [];
        for (let i in map_points) {
            const item = map_points[i];
            if (('price' in item) && !item.price) {
                continue;
            }
            if (('count' in item) && !item.count) {
                continue;
            }
            ret.push({
                id: item.id,
                name: item.name,
                longitude: item.longitude,
                latitude: item.latitude,
                price: item.price,
                count: item.count,
                unit: item.unit || '个楼盘',
                level,
            });
        }

        return ret;
    }

    //二手房地图点位
    async getUsedHouseMapPoint(area_code, level) {

        const { ctx } = this;
        let map_points = [];
        if (level == 1) {
            map_points = await ctx.blockModel.HousePriceMap.all({ where: { pid: area_code } });
        } else if (level == 2) {
            map_points = await ctx.blockModel.HousePriceMap2.all({ where: { pid: area_code } });
        } else {
            map_points = await ctx.blockModel.HousePriceMap3.all({ where: { pid: area_code } });
        }

        if (!map_points || map_points.length === 0) {
            return [];
        }
        const ret = [];
        for (let i in map_points) {
            const item = map_points[i];
            if (('price' in item) && !item.price) {
                continue;
            }
            ret.push({
                id: item.id,
                name: item.name,
                longitude: item.longitude,
                latitude: item.latitude,
                price: item.price,
                unit: item.unit || '元/平',
                level,
            });
        }

        return ret;
    }

    //存钱罐计算完毕后 生成购房计划
    async generateHousePlan(input) {

        const { ctx } = this;
        const down_payment = input.down_payment || 0;//首付金额
        const invest_payment = input.invest_payment || 0;//投资金额
        const prepare_time = input.prepare_time || 6;
        const balance = down_payment - invest_payment;
        let notice = '';
        let status = 0;
        let invest_items = [];
        if (balance <= 0) {
            status = 2;//完全有能力买到房
            notice = '您的资金已满足本项目首付条件，还有更多项目在您预算范围内。一键预约，轻松看房！';
            return { status, notice, invest_items };
        }
        const rate = balance / invest_payment;
        if (rate >= 0.5) {
            status = 0;//完全没有希望能买到房
            notice = '非常遗憾，您的首付预算距离购买该项目尚有较大差距，您可以选择以下方案：';
        } else {
            status = 1;//j加把劲还是有希望买到房
            notice = '恭喜您！依据以上计划，您即将完成XXX项目首付款准备。您现阶段首付预算可以购买以下项目房源：';
            const invest_plans = await ctx.blockModel.HouseInvestPlan.one({ where: { condition_min: { $lt: rate }, condition_max: { $gte: rate }, status: 'online', valid: 1, period: prepare_time } });
            if (Object.keys(invest_plans).length !== 0 && invest_plans.items) {
                invest_items = invest_plans.items;
            }
        }

        return { status, notice, invest_items };
    }

    //存钱罐计算完毕后 生成购房计划
    async generateHousePlan_2_1(input) {

        const { ctx } = this;
        const down_payment = input.down_payment || 0;//首付金额
        const invest_payment = input.invest_payment || 0;//投资金额
        const prepare_time = input.prepare_time || 6;
        const balance = down_payment - invest_payment;
        let notice = '';
        let status = 0;
        let invest_items = [];
        if (balance <= 0) {
            status = 2;//完全有能力买到房
            notice = '您的资金已满足本项目首付条件，还有更多项目在您预算范围内。一键预约，轻松看房！';
            return { status, notice, invest_items };
        }
        const rate = balance / invest_payment;
        if (rate > 10) {
            status = 0;//完全没有希望能买到房
            notice = '非常遗憾，您的首付预算距离购买该项目尚有较大差距，请修改购房计划，重新尝试！';
        } else {
            status = 1;//加把劲还是有希望买到房
            notice = '恭喜您！依据以上计划，您即将完成此项目首付款准备。您现阶段首付预算可以购买以下项目房源：';
            const invest_plans = await ctx.blockModel.HouseInvestPlan.one({ where: { condition_min: { $lt: rate }, condition_max: { $gte: rate }, status: 'online', valid: 1, period: prepare_time } });
            if (invest_plans !== null && invest_plans.items) {
                invest_items = invest_plans.items;
                if (invest_items.length === 0) {//差距还是太大 投资期限过长 不宜买房
                    status = 0;
                    notice = '非常遗憾，您的首付预算距离购买该项目尚有较大差距，请修改购房计划，重新尝试！';
                }
            }
        }

        return { status, notice, invest_items };
    }
}

module.exports = ToolService;
