'use strict';


const moment = require('moment');

module.exports = app => {
  const { STRING, INTEGER, DATE } = app.Sequelize;

  const CourseV5InstitutionRedeemCode = app.classModel.define('course_v5_institution_redeem_code', {
    id: {
      type: INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    code: STRING,
    institution_id: INTEGER,
    class_id: INTEGER,
    user_uuid: STRING,
    is_used: INTEGER,
    status: INTEGER,
    is_deleted: INTEGER,
    used_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('used_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
    created_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('created_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
    updated_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('updated_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
  }, {
    timestamps: false,
    tableName: 'course_v5_institution_redeem_code',
  });

  return CourseV5InstitutionRedeemCode;

};
